
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   LABMON.C - Main Labmon Module
// 
//
//   DESCRIPTION
//
//   Main data processing and control loop functions for Labmon.
//
//
//   LINK NOTE:  Labmon requires approx. 10K (10240 bytes) of stack space, which
//   may be larger than the default stack size allocated by your linker.  Refer
//   to your linker documentation for instructions on how to set stack size.
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\LABMON.C_v  $
//   
//      Rev 1.25   07 Jan 2000 14:54:46   phungh
//   Labmon60 : Add initialization for
//   vEEPAvailable and vEEPBlockBitmap when
//   resetting the Rx with F1 key
//   
//      Rev 1.24   15 Dec 1999 14:26:02   phungh
//   Take out msg1392, Add msg1292 to 
//   accommodate the msg ID change in the
//   zodiac software ver2.57
//   
//      Rev 1.23   08 Dec 1999 16:12:12   phungh
//   Add vEEP test capability, options for 
//   selectively clearing eeprom, and misc...
//   
//      Rev 1.22   27 Apr 1999 15:06:26   phungh
//   labmon55 : Modification for AMD flash
//   download. 
//   
//      Rev 1.21   21 Apr 1999 11:39:48   phungh
//   Labmon54 : Add initialization for Cnt1050,
//   Cnt1051, Cnt1150
//   
//      Rev 1.20   15 Dec 1998 14:27:04   phungh
//   Labmon53 : Fix flash download in "slow
//   mode" ,and record "in/out of NAV"
//   occurance using "xtract COV"
//   
//      Rev 1.19   11 Nov 1998 11:52:08   phungh
//   lbmon522 : Add logging the EVPE to file
//   "cov.txt" when the EVPE value is crossing
//   the set value in either direction.  Changes 
//   made to labmon.c and msg1000.c
//
//      Rev 1.18   11 Nov 1998 10:37:50   phungh
//   lbmon521: Log the EHPE to file "cov.txt"
//   when the EHPE value passing the set 
//   value in either direction.  Change made to
//   labmon.c and msg1000.c.
//
//      Rev 1.17   10 Nov 1998 18:09:48   phungh
//   labmon52: Fix extract data bug.  svout()
//   did not get called at " case 16 : " which is
//   quitting program.
//
//      Rev 1.16   10 Nov 1998 13:54:28   phungh
//   Lbmon511: Add cF7 key combination to
//   the menu to allow choosing antenna type
//   ( passive / active ).  Msg1218 module was
//   added.
//   
//      Rev 1.15   09 Nov 1998 10:26:50   phungh
//   labmon51: Fix file logging and missing 
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of
//   time spent too long in the interrupt handler
//
//      Rev 1.14   Jul 06 1998 09:08:00   BANHND
//   added more DR features
//   
//      Rev 1.11   Jul 09 1997 09:46:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.9   Feb 25 1997 14:29:44   COLEJ
//   added 1117,1208,1317 message support
//   changed delta proccessing to geopos matrix
//   added higer IRQ levels.
//   made cosmetic changes to screen
//   added alt i function - new IRQ settings
//   
//      Rev 1.8   Feb 12 1997 16:05:04   COLEJ
//    
//   
//      Rev 1.7   Nov 14 1996 11:25:12   COLEJ
//    
//   
//      Rev 1.6   Oct 31 1996 11:28:22   COLEJ
//    
//   
//      Rev 1.5   Aug 26 1996 18:42:42   COLEJ
//    
//   
//      Rev 1.4   Aug 19 1996 17:11:48   COLEJ
//    
//   
//      Rev 1.3   Aug 16 1996 16:57:06   COLEJ
//   Added extraction of raw almanac to a file.
//   
//      Rev 1.2   Aug 15 1996 16:52:52   COLEJ
//   Added option to remove the sign from LAT and LON on LLA extraction.
//   
//      Rev 1.1   Aug 13 1996 17:31:12   COLEJ
//   Added MSG1108 processing.
//   Added FXTRACT feature.
//   Added SV data extraction feature.
//   Added allowance to set SPD units.
//   Changed main screen positions removing UTCNSECS
//   
//   
//      Rev 1.0   13 May 1996 14:52:32   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <share.h>
#include <graph.h>
#include <math.h>
#include <string.h> 
#include <sys\timeb.h> 
#include <time.h>
#include <ctype.h>   

#include "ALM_SEND.H"
#include "EPH_SEND.H"
#include "UTC_SEND.H"
#include "INITFUNC.H"
#include "MESS_IO.H"
#include "LABMON.H"
#include "MONMISC.H"
#include "MONSHOW.H"
#include "SENDNMEA.H"
#include "MENUS.H"
#include "DISPLAY.H"
#include "GENTYPES.H"
#include "ZCONS.H"
#include "ZTYPES.H"
#include "UTIL.H"

#ifdef __WATCOMC__
#include <i86.h>
#define _ftime     ftime
#define _timeb     timeb
#define _fcloseall fcloseall
#endif

// WATCHDOG STUFF
short WATCHDOG  =   0;  // Flag WatchDog Timer enabled
short WDTimeOut = 30;  // WatchDog TimeOut seconds
enum WDStateType { sWaitNav = 0, sWaitAck, sCheckSats, sWatchDog } WDState;    
short      FirstTime = 1;
unsigned short WDTimeRemaining = 0;

// TERMINAL STUFF
short TERMINAL = 0;
short TermDataType = BINARY;

// FLAGS
tBOOL DEBUG = 0; 
tBOOL Flag1102 = TRUE; // flag to switch to displaying 1191 if 1102 invalid
tBOOL OldFlag1102 = TRUE; // should be initialized to Flag1102 value
tBOOL Display1070 = 0;
tBOOL DisplayDRError = 0;

short delta     = 0;  
short filter_on = 0; 

extern short DataLen;             
extern float mask_angle;     
extern short mask_num;     
extern short utcoffset;     

short ictr = 0;

struct _timeb  timebuffer;

unsigned short   timerchange = 0;
double         cnttime_ref = 0.; 
float          dtplay      = .025f;
unsigned long  alm_delay;

double         ref_lat, ref_lon, ref_alt;
tGeoPos GeoPos, RefGeoPos; // strutures for lat/lon/alt
double  ENU[3];            // used for delta positions  
double  dlat, dlon, dalt;  // used for delta positions in lla extraction


// color support
short MainTextColor;  
short MainDataColor;  
short MainBackColor;
short MenuKeysColor;  
short MenuDescColor;  
short MenuBackColor;        
short MainBackColorIndex;
short MenuBackColorIndex;  

// color variables used for text (foreground):
//   black   0        grey            8
//   blue    1        bright blue     9
//   green   2        bright green   10
//   cyan    3        bright cyan    11
//   red     4        bright red     12
//   magenta 5        violet         13
//   orange  6        yellow         14
//   white   7        bright white   15
      
extern unsigned long  cnt101 , cnt102 , cnt103 , cnt104 , cnt105 ;
extern unsigned long  cnt106 , cnt107 , cnt111 , cnt112 , cnt117 ;
extern unsigned long  cnt113 , cnt152 , cnt153 , cnt201 , cnt202 ;
extern unsigned long  cnt203 , cnt204 , cnt205 , cnt206 , cnt207 ;
extern unsigned long  cnt208 , cnt209 , cnt210 , cnt211 , cnt213 ;
extern unsigned long  cnt215 , cnt217 , cnt220 , cnt2309, cnt2319;
extern unsigned long  cntnack, cntncs , cnthcs , cntdcs , cntovf , cntsyn ;
extern unsigned long  cntalm , cntgga , cntgll , cntgsa , cntgsv ;
extern unsigned long  cntrmc , cntvtg , cntzda , cntalt , cntcom ;   
extern unsigned long  cntdgp , cntinit, cntlog , cntq   , cntftst, cntgen ;
extern unsigned long  cnticom, cntidgp, cntzch , cnterr , cntrid ;
extern unsigned long  cntilog, cntipro, cntibit, cntbit;      

extern unsigned long  Cnt1000, Cnt1001, Cnt1002, Cnt1003;
extern unsigned long  Cnt1005, Cnt1007, Cnt1008, Cnt1009, Cnt1011, Cnt1012;
extern unsigned long  Cnt1040, Cnt1041, Cnt1042, Cnt1050, Cnt1051;
extern unsigned long  Cnt1070, Cnt1071, Cnt1072, Cnt1075, Cnt1090, Cnt1091, Cnt1092;
extern unsigned long  Cnt1100, Cnt1102, Cnt1106, Cnt1108, Cnt1110, Cnt1117, Cnt1130;
extern unsigned long  Cnt1135, Cnt1136, Cnt1137, Cnt1138, Cnt1150, Cnt1160; 
extern unsigned long  Cnt1170, Cnt1171, Cnt1172, Cnt1173, Cnt1180, Cnt1190, Cnt1191;
extern unsigned long  Cnt1200, Cnt1208, Cnt1210, Cnt1211, Cnt1212, Cnt1213;
extern unsigned long  Cnt1214, Cnt1216, Cnt1217, Cnt1218, Cnt1219, Cnt1220, Cnt1221;
extern unsigned long  Cnt1240, Cnt1241, Cnt1242, Cnt1270, Cnt1292;
extern unsigned long  Cnt1300, Cnt1303, Cnt1304, Cnt1305, Cnt1306; 
extern unsigned long  Cnt1310, Cnt1317, Cnt1330, Cnt1331;   
extern unsigned long  Cnt1334, Cnt1337, Cnt1350, Cnt1351, Cnt1360, Cnt1380;   
extern unsigned long  CntZLog, CntZQry;     
extern unsigned long  CntNav , CntPnt;

short MsgID       = 0;  
short MsgTrigger  = 0;
short MsgInterval = 1;
short MsgOffset   = 0;
short MsgFlags    = 0;
    
static char d_ctl  = 'A';
static char d_rst  = 'V';
static char d_ctl2 = 'A';

short rockwell_link = 0;  
unsigned short datum = 0;
short menu_on = 1;  
short valid = 0;
short msgptr = 1;
short nrtcm  = 0;   
short numtype1 = 0, numtype2 = 0, numtype5 = 0, numtype9 = 0; 
short rtcmbytes = 0;
short eodata = 0; 
short playback = 0;  // 1 for debug, change 0 for release
short pause    = 0;  // 1 for debug, change 0 for release  
short step     = 0;                  

short xtract   = 0;
short fxtract  = 0;  // new for fast extracting (john)  
char  xtractid[5] = "LLA";
short xtractchannel = 1;
tBOOL ABS_LLA;              // flag take absolute value of lat and log for plotting 
char  YN_LLASIGN[3]= "N";   // input var for yes/no of absolute lat log
char  YN_FXTRACT[3]= "N";    // input var for yes/no of fast extracting
char  dxt[5]      = "ALL";  // input var for type data to extract
extern tBOOL  COLLECT_EPH,  // flag to extract ephemeris data
              COLLECT_ALM,  // flag to extract almanac data
              COLLECT_UTC;  // flag to extract utc data

unsigned short InvalidateRAM;
unsigned short InvalidateEEPROM;
unsigned short InvalidateRTC;
unsigned short DisableEEPROMPos;
unsigned short ColdStartDisable;
unsigned short ColdStartTimeOut;

short  LoadFrqTbl = 0, StoreFrqTbl = 0;
short  LoadFrqPar = 0, StoreFrqPar = 0;

fpos_t fpos[max_fpos];  
fpos_t pos;   
short  ifpos = 0, nfpos = 0;  

short Send_Byte; // Byte from Send File

short gpsrecord = 0, difrecord = 0;
short gpsfileopen = 0, diffileopen = 0, plyfileopen = 0, extfileopen = 0;
short gpsrecfilen = 97, difrecfilen = 97; 
char  gpsrecfile[32], difrecfile[32], gpsplyfile[32];
char  gpsextfile[32], frqtblfile[32], frqparfile[32]; 
char  tempchar[8];  
short have_sync  = 0; 
short FlashMode  = 0;
short cr_found   = 0;  
short lf_found   = 0; 
short ast_found  = 0; 

FILE *stream, *stream2, *stream3, *stream4,*stream5,*inidata,
     *cfgdata,*stream6,*stream7,*stream8,*almdata,*Send_FilePtr,
     *MagnaMeasFilePtr;


char buff[80];                         /* Display Buffer */   
char nmea_msg[80];
char Data_File_Name[13];
unsigned char msgbuff[MAX_MSG_BUFFER];                /* Local Buffer */
unsigned char dgpsbuff[MAX_DGPS_RX_BUFFER];               /* Local Buffer */ 
short alm_rate = 1;

unsigned short gpsport, gpsirq, gpsvector;
unsigned short difport, difirq, difvector;    
unsigned short outport, outirq, outvector;    

unsigned short gps_head, dgps_head;
unsigned short gps_tail, dgps_tail;
BYTE rx_buff[MAX_RX_BUFFER+1], dgps_rx_buff[MAX_DGPS_RX_BUFFER]; //+1]; 

// Zodiac message super-structure
//
tZMSG   ZMsg;

// Unpacked versions of Zodiac message (sub)structures
//
tDIFFSTATUSBITS     DiffStatusBits;                 // diff status
tCORRSTATUSBITS     CorrStatusBits[GI_MAX_VIS_SVS]; // corr status
tSOLUTIONSTATUSBITS SolutionStatusBits;             // sol validity stat
tCHNSUMDATA         ChnSumData[GI_NUM_HW_CHAN];   // chan summary
tINITVALIDDATA      InitValidData;                  // init validity
tINITMODEDATA       InitModeData;                   // init timing mode data
tCOMMANDWORD        CommandWord;                    // command word
tSOLVALIDDATA       SolValidData;                   // sol validity data
tNAVCFGBITS         NavCfgBits;                     // nav config
tCONFIGDATA         ConfigData;                     // config data
tBOOL               CandidatePRN[32];               // candidate SV PRNs
tSPVALIDDATA        SPValidData;                    // serial port cfg
tANTENNADATA        AntennaData;                    // antenna
tDGPSCONTROLDATA    DGPSControlData;                // DGPS control
tCOLDSTARTDATA      ColdStartData;                  // cold start
tUSERALTINPUTDATA   AltInputData;                   // altitude input
tBOOL               DeviceNotPresent;               // device status
tBOOL               vEEPROMStatus;                  // vEEPROM checksum status
tEEPROMUPDATEDATA   EEPROMUpdateData;               // EEPROM update
tFRQTBLDATA         FrqTblData[256];                // freq table
tBITS1170           Bits1170;                       // bitfield in 1170
tBITS1171           Bits1171;                       // bitfield in 1171
tBESTCHANSUM        BestChanSum[GI_NUM_HW_CHAN];    // Best Channel Data for DR

tMSGBUF ZMsgBuf;  // zodiac msg processing buffer

short RTCMPacketLen;
short RTCMType5Enable, StaticNavEnable;  
short PrDgpsCorr = 0, PrTropCorr = 0, PrClkCorr = 0, PrReq = 0;
short DGPS_ON =1;

short PCMCIA_GPS = 0x0B;

short Auto_2D;

tDATATYPE DataType = Z_BINARY;  // default to Zodiac binary

short spdunits = 0;  // used to set output units for SPD field (set in cfg)

unsigned short SVs01To16 = 0xFFFF;
unsigned short SVs17To32 = 0xFFFF;


unsigned char tx_buff[MAX_TX_BUFFER]; //+1];  //?
unsigned char filebuff[4000];

double lat = 0, lon = 0, alt = 0;
double out_lat, out_lon, out_alt;
short GPS_Time_Valid = FALSE; 
double osc_freq = 10.949296875;
float  osc_ppm = 0;  

float  maxpdop = 6;
float  maxhdop = 6;
float  maxvdop = 6;
short  minsats = 3;
short  minfom  = 5;
short  minqual = 1; 
unsigned short StatMask = 0xFFFF;
   
extern short   gps_qual;     
extern short   nsats_used; 

short BITTest = FALSE;                   /* Toggling BIT Test Display */
short In_Nav_Mode = FALSE;               /* Set When In Navigation */
short SatsInAlm=0, BlocksRec = 0;        /* Used For Almanac Data 104 */ 
short rec_cnt, rec_cnt_2, data_len, file_len = 0;
short want_exit;
short save = 0, save2 = 0;
short gps_open  = 0, open_gps  = 0;
short dgps_open = 0, open_dgps = 0;  
short out_open = 0, open_out = 0;  

short gpscom, gpsnbit, gpssbit, tempnbit, tempsbit; /* temprate, tempsbit, tempnbit, tempprty */
long gpsbaud, temprate;                             /* are used for flash download            */
short outcom, outbaud, outnbit, outsbit;
short difcom, difbaud, difnbit, difsbit;
static short auxdbit = 8, auxsbit = 1;
static long auxbaud = 9600; 
short auxstat;
short auxwcnt;
char  gpsprty, difprty, outprty, auxprty, tempprty = 'N'; 
char  *Clear = "                   "; 
char  *Clear80 =
"                                                                              ";
short cmdline      = 43; // 25, 43 or 50 for textc80 mode
short current_menu = 1;

void (__interrupt __far *old_serial)();
void (__interrupt __far *old_dgps)();
void (__interrupt __far *old_out)();
short _gps_InitPort(short port, short IRQ, long rate, char gpsprty, short gpsnbit, short gpssbit);
short _out_InitPort(short port, short IRQ, long rate, char outprty, short outnbit, short outsbit);
void  _gps_ReleaseIRQ(short IRQ);
void  _out_ReleaseIRQ(short IRQ);
void InitTime(short hour, short min, short day, short month, short year);
short OpenDGPS(short port, short IRQ, long rate, char difrty, short difnbit, short difsbit);
//short OpenGPS(short port, short IRQ, long rate, char gpsprty, short gpsnbit, short gpssbit);
short OpenOut(short port, short IRQ, long rate, char outprty, short outnbit, short outsbit);
void  CloseGPS(void);
void  CloseOut(void);
void  CloseDGPS(void);
void  FlushGPS(void);
void  FlushDGPS(void);
void  proc_cfg(void);
void  write_cfg(void);
void  save_cfg(void);
void  proc_ini(void);
void  write_ini(void);  
void  save_ini(void);
void  proc_args(short argc, char *argv[]);   
void SetGMT(void);   
void Molodensky(short datum);        
void show_diff_status(void);  
void process_nmea(void); 
void NSetSerialComm(void);
void ZSetSerialComm(void);
unsigned short vector(unsigned short);
 
short  msg_support(short); 
void wait(float);  
void reset_dtime(void);  
void show_xtract(short);
void show_filter(short);
void DoExplicitAck(tSHORT, tBOOL);
void DovEEPBlockInput(void);

extern void svout();       //output routine for sv data (xsvd.c)
extern void ProcFlash(void);
extern int  OpenRFBFile(void);
extern void SendRFBBlock(unsigned short);
extern void ChangeBaud(void);

// global variables used in various file through extern

// VEEPROM Data 
#define VEEPROM_NUM_WORDS           2048     // Change this if the vEEPROM size changes.
#define VEEPROM_NUM_BLOCKS          VEEPROM_NUM_WORDS / 128
FILE     *vEEPROMFilePtr; 
tSHORT   vEEPROM_file_size;

tUSHORT BlockID = 0;
tBOOL   vEEPDataBlkTransfer = FALSE;
tBOOL   vEEPValidStatusSent = FALSE;
tUSHORT vEEPBlockBitMap     = 0; 
tSHORT	vEEPResend			= 0;
tBOOL	vEEPAvailable	    = TRUE;
tBOOL   vEEPTransferInProgress = FALSE;
tBOOL   vEEPRequired		   = FALSE;
tBOOL	ReceivedAckOfLastvEEPMsg = FALSE;
tBOOL	vEEPTest			= FALSE;
tUSHORT TempStore[VEEPROM_NUM_WORDS]={0};

/*********TEST CODE FOR RESETTING RECEIVER
tBOOL ReSet=FALSE;
short CountByte=0;
short RowByte=40;                         
******************************************/

void main(short argc, char *argv[])
{ 

   unsigned short  j          = 0;
   short           i          = 0; 
   short           bytein     = 0; 
   unsigned char   nmeacs     = 0; 
   unsigned char   nmeatmp    = 0;
   short           first_sync = 0;

 
   short         cs         = 0;
   char          kch;
   unsigned long delay      = 0;
   long          flen       = 0;
   long          cntovf     = 0;
   KeyboardType  kb;       
              
   // play title screen (leadin)
   //TitleScreen(0);

   // set up the program using config file  
   proc_cfg();
  
   // set up ports using the ini file  
   proc_ini();

   // process any command line file arguments   
   proc_args(argc, argv);
  
   // setup the screen
   _setvideomoderows(_TEXTC80,cmdline);
   // _setvideomoderows(_VRES16COLOR, cmdline);
   // _setvideomoderows(_SRES16COLOR, cmdline); 
   _setbkcolor(MainBackColor);   
   _settextcolor(MainDataColor);
   _clearscreen(_GCLEARSCREEN);
   _settextcursor(0x2000);      /* Turn Cursor Off */
   
   // reset counter reference time to system time   
   reset_dtime();

   // setup screen   
   current_menu = 4;
   display_menus(&current_menu);
   display_title();
   show_screen_titles(); 
 
  
   // initialize control variables
   want_exit     = 0;
   rec_cnt       = 0;
   rec_cnt_2     = 0;
   data_len      = 10;
   RTCMPacketLen = 20;
   have_sync     = 0;
   kch           = ' ';
   cntovf        = 0;
   delay         = 0l;        

   open_gps      = 1;
   open_dgps     = 1;     
   open_out      = 0;
  
   // do until exit wanted or end of data file
   while(!want_exit){
   
      // monitor keyboard
       if(kbhit()){
         kb = getkey(GETKEY);
         process_kbd(kb);
      }  

      // check watchdog
      if(WATCHDOG){
        sprintf(buff,"%02hu" , WDTimeRemaining);ShowText(buff,SPDR+ 2,SPDC+ 8);                                    
        WatchDog();
      }
      
      // wait until time to run  
      if(pause){
         continue;
      }    
        
      if(!gps_open && open_gps){  
         // try to open gps port
         switch(gpscom){
            case  1: gpsport = 0x3F8; break;
            case  2: gpsport = 0x2F8; break;
            case  3: gpsport = 0x3E8; break;
            case  4: gpsport = 0x2E8; break;
            default: gpsport = 0    ; break;
         }
         clear_message_line();
         if(gpsport && !playback){
            _settextposition(cmdline, 1);
            if(OpenGPS(gpsport, gpsirq, gpsbaud, gpsprty, gpsnbit, gpssbit)==0){;
               sprintf(buff,"GPS PORT: COM%1d IRQ%2d LOC %3X ",
                            gpscom, gpsirq, gpsport);
               _outtext(buff);  
               open_gps = 0;
            }
            else{
               sprintf(buff,"GPS PORT: COM%1d IRQ%2d LOC %3X NOT FOUND ",
                             gpscom, gpsirq, gpsport);
               _outtext(buff);
              //abort();    
            }
         } 
      }         
      
      if(!dgps_open && open_dgps){  
         // try to open dgps port
         switch(difcom){
            case  1: difport = 0x3F8; break;
            case  2: difport = 0x2F8; break;
            case  3: difport = 0x3E8; break;
            case  4: difport = 0x2E8; break;
            default: difport = 0;     break;
         }  
         if(difport && !playback){
            _settextposition(cmdline, 31);
            if(OpenDGPS(difport, difirq, difbaud, difprty, difnbit, difsbit)==0){;
               sprintf(buff,"RTCM PORT: COM%1d IRQ%2d LOC %3X ",
                             difcom, difirq, difport);
               _outtext(buff); 
               open_dgps = 0;
            }
            else{
               sprintf(buff,"RTCM PORT: COM%1d IRQ%2d LOC %3X NOT FOUND ",
                             difcom, difirq, difport);
               _outtext(buff);
               //abort();    
            }
         }
      }   
    
      if(!out_open && open_out){  
         // try to open out port
         switch(outcom){
            case  1: outport = 0x3F8; break;
            case  2: outport = 0x2F8; break;
            case  3: outport = 0x3E8; break;
            case  4: outport = 0x2E8; break;
            default: outport = 0    ; break;
         }
         clear_message_line();
         if(outport && playback){
            if(OpenOut(outport, outirq, outbaud, outprty, outnbit, outsbit)==0){;
               sprintf(buff,"PLAY PORT: COM%1d IRQ%2d LOC %3X ",
                            outcom, outirq, outport);
               _outtext(buff);  
               open_out = 0;
            }
            else{
               sprintf(buff,"PLAY PORT: COM%1d IRQ%2d LOC %3X NOT FOUND ",
                             outcom, outirq, outport);
               _outtext(buff);   
            }
         } 
      }

      if(FlashMode && !Cnt1180) {
          Cnt1380++;
          send_msg(tx_buff);  
      }             
      
      // check whether live data or data playback
      if(!playback){ 
         
         // only build 210 messages for navcore binary protocol
         if(difport && ((DataType == NC_BINARY) || (DataType == Z_BINARY))){
         
            // Limit xmit of 210's to 1/4 sec
            if(labs((delay+5)-timer()) > 5){  
               
               // get a byte from the RTCM port
               j = get_byte_2(); 

               if((j > 0x3F) && (j < 0x80)){
    
                  dgpsbuff[rec_cnt_2] = (unsigned char) j;
                  rec_cnt_2++;

                  if(rec_cnt_2 >= (RTCMPacketLen * 2)){
                     if (DataType == NC_BINARY){
                        make_tx_header(210, RTCMPacketLen + 6);  // Header
                        for(i=0; i < RTCMPacketLen * 2; i++){
                           tx_buff[i+10] = dgpsbuff[i];  // Copy to tx buffer
                        } 
                        cnt210++;   
                     }
                     else { // Zodiac binary (in-line hack)
                        *((unsigned short *)tx_buff)      = 0x81FF;
                        *((unsigned short *)(tx_buff+2))  = 1351;
                        *((unsigned short *)(tx_buff+4))  = RTCMPacketLen+1;
                        *((unsigned short *)(tx_buff+6))  = ANREQ;
                        *((unsigned short *)(tx_buff+10)) = 0;
                        for (i=0; i < RTCMPacketLen * 2; i++){
                           tx_buff[12+i] = dgpsbuff[i];  // Copy to tx buffer
                        } 
                        Cnt1351++;   
                     }
                     send_msg(tx_buff);
                     rec_cnt_2 = 0;
                     delay = timer();
                  } 
               }
            }
         } 
         
         // get a byte from the receiver port
         bytein = get_byte();
      } 
      else{
         // read a byte from data file
         bytein = read_byte();
      }
           
      if(bytein == -1){
         // no new bytes, restart loop
         continue; 
      }     
      
      // Terminal
      if(TERMINAL){
        if((DataType == Z_NMEA) || (DataType == NC_NMEA)){
          sprintf(buff,"%c",bytein);
          _outtext(buff);
        }
        else{
          sprintf(buff,"%02hX",bytein);
          _outtext(buff);
        }
        continue;
      }

/**********THIS TEST CODE IS TO LOOK AT THE FIRST 60 
		   BYTES OUTPUT BY THE RECEIVER AFTER RESET**********/
//      if(ReSet) {
//          sprintf(buff,"%02hX",bytein);
//          _settextposition(RowByte,CountByte*2+1);
//          _outtext(buff);
//          CountByte++;
//          if(CountByte == 30) {
//             CountByte = 0;    
//             RowByte++;
//             if(RowByte >= 42) {
//                ReSet = FALSE;
//                CountByte = 0;
//                RowByte = 40;
//             }
//          }
//      }
/************************************************************/ 
            
      // establish sync
      if(!have_sync){
         // check data type   
         if((DataType == Z_NMEA) || (DataType == NC_NMEA)){
            // check for $ at start of nmea message
            if((bytein == 0x24) && (!have_sync)){  
               have_sync = 1;
               rec_cnt   = 0; 
               cs        = 0;   
               msgbuff[0] = (unsigned char) bytein;
            } 
            else{  
               // check whether $ was found when last byte was a line feed
               if(lf_found){
                  // check for spaces output by older microtrackers
                  if(bytein != 0x20){ 
                     // sync or comm error caused partial message or garbage data
                     cntsyn++; 
                     lf_found = 0;
                  }
               }
            }
            continue;
         }
         else{
            // binary data
            if((bytein == 0xFF) && (!first_sync)){   
               // first synch byte
               first_sync = 1; 
            }
            else if((bytein == 0xFF) && (first_sync)){
               // don't reset first_sync to 0
               // because we might throw away this 0xFF which
               // may be the beginning of a message.  This happens when we have
               // a data stream as : FFFF81... which usually
               // happens after resetting the receiver.
               ;
            }
            else if((bytein == 0x81) && (first_sync)){            
               // second synch byte 
               rec_cnt +=2;

               // put header bytes in buffer
               *((unsigned short *)(msgbuff))= 0x81FF; 
               have_sync  = 1;
               first_sync = 0; 
            }
            else{
               first_sync = 0; 
            }
         }
         continue;
      }

      // check for buffer overflow
      if(rec_cnt > MAX_MSG_BUFFER){
         rec_cnt = 0; 
         have_sync = 0; // new
         cputs("\a");
         cntovf++;
         sprintf(buff,
                "MESSAGE BUFFER OVERFLOWS %ld, CHECK MESSAGE PROTOCOL!",cntovf);
         clear_message_line();
         _outtext(buff);  
         _fmemset(msgbuff, 0, sizeof(msgbuff));  
         //wait(1.f); 
         continue;
         //break; // new
      }

      // check for NMEA-0183 data or Rockwell binary
      if((DataType == Z_NMEA) || (DataType == NC_NMEA)){  // process nmea data
         
         // save data in buffer
         msgbuff[++rec_cnt] = (BYTE) bytein;         
          
         // build message 
         
         // used to check for sync errors indicated by data between line feed and $ 
         lf_found = 0;
         
         if(bytein == 0x0D){
            // carriage return found
            cr_found = 1;
         }
         else if(bytein == 0x0A && cr_found){
            // line feed found, message complete
            lf_found = 1; 

            // read checksum and check
            nmeatmp = msgbuff[rec_cnt-3];       // first nibble
            if(nmeatmp > 47 && nmeatmp < 58){
               nmeatmp -= 48;    // numeric
            }
            else if(nmeatmp > 64 && nmeatmp < 71){
               nmeatmp -= 55;    // alpha
            }           
            nmeacs = nmeatmp << 4;                    
            nmeatmp = msgbuff[rec_cnt-2];       // second nibble
            if(nmeatmp > 47 && nmeatmp < 58){
               nmeatmp -= 48;    // numeric
            }
            else if(nmeatmp > 64 && nmeatmp < 71){
               nmeatmp -= 55;    // alpha
            }
            nmeacs |= nmeatmp;                  // checksum byte
   
            // checksums are optional
            if(ast_found && cs != nmeacs){
               // failed nmea checksum
               cntncs++;
            }
            else{
               // message is good
               
               // print message before changing buffer and reset pointer
               rec_cnt--;
               strncpy(nmea_msg, msgbuff, rec_cnt);
               nmea_msg[rec_cnt] = '\0';
               msgbuff[rec_cnt] = '\0';           
               clear_message_line();
               _outtext(nmea_msg);               
               //pause = 1;   
            
               // process nmea message
               process_nmea();  
                
               // update the message count
               show_count(); 
               
               // check and save the file position to enable backup
               if(fgetpos(stream, &pos) != 0){
                  // error
               }
               else{ 
                  fpos[nfpos] = pos;
                  nfpos++;
                  if(nfpos > max_fpos) nfpos = 0;     
               }
            }
            
            // single step playback
            if(step){  
               // no need to wait
               pause = 1;
            }
            else{  
               // wait for the play interval
               wait(dtplay);
            }
            
            // reset sync and counter variables
            rec_cnt   = 0;
            have_sync = 0; 
            cr_found  = 0;
            ast_found = 0;
            _fmemset(msgbuff, ' ', sizeof(msgbuff));  
            _fmemset(nmea_msg, ' ', 80);  
         }
         else if(bytein == 0x2A){
            // asterisk found   
            ast_found = 1;
         }
         
         // compute checksum after $ and before *<CR><LF>
         if(!ast_found){
            cs ^= (short) bytein; 
         }      
      }
      else{
         // process binary data
         if(rec_cnt){ 
         
            // put data in buffer
            msgbuff[rec_cnt++] = (BYTE) bytein;  

            // get message length and number of data bytes
            if(rec_cnt == 6){     
               i = get_I16(3);              
               rtcmbytes = 2 * i;       
               data_len  = 2 * i + ((i>0)?12:10);  
            }
                                
            // check for complete message
            if(rec_cnt == data_len){

               // message ready to process
               if(get_cs(msgbuff,10)){
                  // Bad header Checksum
                  cnthcs++;
                  cprintf("\a"); 
                  clear_message_line(); 
                  _outtext("HEADER CHECKSUM ERROR");
                  if(FlashMode)
                     SendRFBBlock(1);
                  DoExplicitAck(*(tSHORT *)&msgbuff[2], FALSE); //negative explct ack.
               }
               else if(data_len>12 && get_cs(msgbuff+10,data_len-10)){
                  // Bad data Checksum
                  cntdcs++; 
                  cprintf("\a");
                  clear_message_line(); 
                  _outtext("DATA CHECKSUM ERROR");
                  if(FlashMode)
                     SendRFBBlock(1);         
                  DoExplicitAck(*(tSHORT *)&msgbuff[2], FALSE); //negative explct ack.
               }
               else{
                  // have a good message
                  if(DataType == NC_BINARY){
                     // process navcore binary protocol
                     process_msg(); 
                     
                     // update the message count
                     show_count();
                  }
                  else if (DataType == Z_BINARY){
                     // process zodiac binary protocol
                     memcpy(&ZMsgBuf, msgbuff, rec_cnt);
                     DecZMsg(&ZMsgBuf, ZMsg);
                     
                     // update the message count
                     show_count();
                     
                     // do positive explicit acknowledge to the receiver
                     // This code is for testing the vEEPROM transfer.
                     DoExplicitAck(*(tSHORT *)&msgbuff[2], TRUE);


                     if(vEEPRequired && (vEEPResend <= 4)) 
                     {
                        vEEPRequired = FALSE;

                        // Send all Blocks to the GPS RX. (16 msg1337)
                        DovEEPBlockInput();

                     }
                        
                  }
                  
                  // check and save the file position to enable backup
                  if(fgetpos(stream, &pos) != 0){
                     // error
                  }
                  else{ 
                     fpos[nfpos] = pos;
                     nfpos++;
                     if(nfpos > max_fpos) nfpos = 0;     
                  }    
                  
                  // single step playback
                  if(step){  
                     // no need to wait
                     pause = 1;
                  }
                  else{  
                     // wait for the play interval
                     wait(dtplay);
                  } 
                  
               }
               rec_cnt   = 0;
               data_len  = 10;
               have_sync = 0;
            }
         }
      }

      // output number of bytes recorded to gps data file
      if(save || playback){
         flen = ftell(stream);
         sprintf(buff, "BYTES: %ld", flen);
         _settextposition(CMDR-3,CNTC+2); _outtext(buff);
      }    
   }

   // close ports and files
   CloseGPS();     
   CloseDGPS();
   CloseOut();         
   _fcloseall();

   // turn cursor back on
   _settextcursor(0x0707);           
   _setvideomode(_DEFAULTMODE);

   // play title screen (leadout)
   //TitleScreen(1);


}  


void process_kbd(KeyboardType kb)  

{
   unsigned short Rate, DGPSTimeOut, DGPSDisable, DGPSReset;  
   unsigned short Platform, AntennaType;
   unsigned short DisableHeldAltitude, DisableGTSmoothing;
   unsigned short DisablePosPinning, DisableLowQualityMeas;
   unsigned short EnableJammingDetect, CN0Threshold=1;
   unsigned short AltNotUsedReq, DGPSRequired, MinimumSats, StorageSelect;
   unsigned short DRMeasRequired, ConGPSRequired, GPSOnlyRequired;
   unsigned short DGPS2DTimeOut, DGPS2DDisable;
   unsigned short dutycycle=0;   
      
   double       SemiMajorAxis, InverseFlattening;
   double       WGS84OffsetdX, WGS84OffsetdY, WGS84OffsetdZ;
   float        MaxEHPE, MaxEVPE;
   
   short i;
   unsigned short DisabledSat = 0; 
   char         dissv[3]; 
   short          DataStream, ProtocolType; 
   short          LoadStore, FrqStdDataType;
   short  tgpsirq, tdifirq; // temp irq setting
   
   short  GyroBias;
   static char   MagnaMeasFileName[15] = "MEASURE.MAG";
   static short  MagnaMode=0, CNoLevel=0;

   char  c;
   
   switch(kb.scan){    
   
      case 12: // -, minus 
         // slow down during replay
         dtplay *= 2.f;
         break;        
                 
      case 13: // =, key has plus on it, no shift required with = 
         // speed up during replay
         dtplay *= .5f;
         break;                
      
      case 15:                // Tab, recording on/off
      	   
/****** capability disabled for this version
      // check for open ports
      if(!gps_open && !dgps_open){
          clear_message_line(); 
          sprintf(buff,"NO INPUT PORTS OPEN FOR RECORDING!"); 
          _outtext(buff); // cputs(\a);                                 
          break;
      }
      gpsrecord ^= 1; 
      fclose(stream); 
      if(gpsrecord){ 
         // open a new file and start recording  
         
         if(gpsfileopen){
            gpsrecfile[6]  = (char) gpsrecfilen++;  
            if((stream = _fsopen(gpsrecfile, "wb", SH_DENYWR)) == NULL){
               save = 0;    
               clear_message_line(); 
               sprintf(buff,"COULDN'T OPEN FILE %s!",gpsrecfile); 
               _outtext(buff);
               gpsfileopen = 0;
            }
            else{
               save = 1;
               clear_message_line();
               sprintf(buff,"RECORDING GPS DATA IN FILE %s",gpsrecfile); 
               _outtext(buff); //cputs("\a\a\a");          
            }
         } 
      }
      else{
         // close a file and stop recording
         if(gpsfileopen){  
            save = 0;    
            clear_message_line();  
            sprintf(buff,"CLOSING GPS DATA FILE %s",gpsrecfile); 
            _outtext(buff); //cputs("\a\a");       
            fclose(stream); 
         } 
      }              
      difrecord ^= 1; 
      fclose(stream2); 
      if(difrecord){ 
         // open a new file and start recording  
         
         if(diffileopen){
            difrecfile[6]  = (char) difrecfilen++;  
            if((stream2 = _fsopen(difrecfile, "wb", SH_DENYWR)) == NULL){
               save2 = 0;    
               clear_message_line(); 
               sprintf(buff,"COULDN'T OPEN FILE %s!",difrecfile); 
               _outtext(buff);
               diffileopen = 0;
            }
            else{
               save2 = 1;
               clear_message_line(); 
               sprintf(buff,"RECORDING RTCM DATA IN FILE %s",difrecfile); 
               _outtext(buff); //cputs("\a\a\a");          
            }          
         }
      }
      else{
         // close a file and stop recording
         if(diffileopen){ 
            save2 = 0;     
            clear_message_line(); 
            sprintf(buff,"CLOSING RTCM DATA FILE %s",difrecfile); 
            _outtext(buff); //cputs("\a\a");       
            fclose(stream);  
            diffileopen = 0;
         } 
      }
******/
      break;

   case 17:                // W
      if(!msg_support(Z_BINARY)) break;       
      if ((kb.shift & 0x08) == 0x08) {  // alt-W
        // WatchDog Timer 
        WATCHDOG ^= 1;  // toggle watchdog timer
        if(WATCHDOG){
           
           WDState = sWaitNav;
           FirstTime = 1;

           clear_message_line();
           WDTimeOut = 
              ask_short("Enter Timeout For WatchDog (seconds) -> ", 
              30, &valid);
           WDTimeRemaining = WDTimeOut;   
           if(!valid) WATCHDOG = 0;
        }
        else{
          sprintf(buff,"%s" , "      ");ShowText(buff,SPDR+ 2,SPDC+ 4);                                    
        }
      }
      break;                 

   case 18:     //  E
      if ((kb.shift & 0x08) == 0x08) {  // alt-E. Request vEEPROM from RX.
         
        if(!msg_support(Z_BINARY)) break;

        ZMsg.Msg1334.SequenceNumber = 0;
        ZMsg.Msg1334.Status = 0x0002;
        ZMsg.Msg1334.Reserved1 = 0;
        ZMsg.Msg1334.Reserved2 = 0; 
        BldZMsg(&ZMsgBuf, ZMsg, 1334);
        memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1334) + HDR_LEN); 
        Cnt1334++;       
        send_msg(tx_buff);
      }
      break;
     
   case 19:                // R 
      if ((kb.shift & 0x08) == 0x08) {  // alt-R
         // reset receiver
         if (ResetReceiver(1)){
            reset_dtime();
            if(!menu_on){
               clear_count();
            }
            clear_screen();
            clear_message_line();
            _outtext("RESTARTING RECEIVER");
            FlushGPS();
            wait(1.f);
         }
         break;     
      }

      //replay data     
      clear_message_line();
      ask_str("GPS PLAYBACK FILE -> ", gpsplyfile, &valid); 
      clear_message_line();
      if(stream != NULL) fclose(stream);             // close file after logging and open immediately, ready for xtract.
      if((stream = _fsopen(gpsplyfile, "rb", SH_DENYWR)) == NULL){
         sprintf(buff,"COULDN'T OPEN FILE %s!",gpsplyfile); 
         _outtext(buff);
      }
      else{ 
         // play recorded data 
         sprintf(buff,"GPS DATA PLAYBACK FILE IS %s",gpsplyfile); 
         _outtext(buff);
         plyfileopen = 1; 
         
         if(extfileopen){
            if(xtract && strcmp(xtractid,"SVD") == 0){
               svout();   //call output routine in xsvd.c to write data
               if(fxtract) fxtract = 0;         // turn off fast extract
            }
            clear_screen();
            clear_message_line();
            sprintf(buff,"CLOSING XTRACT DESTINATION FILE %s",gpsextfile); 
            _outtext(buff); //cputs("\a\a");       
            fclose(stream3);
            extfileopen = 0;
         }  
         gpsrecord = 0;
         difrecord = 0;
         playback = 1; 
         pause = 1;
         save  = 0; // needed?
         save2 = 0;
         CloseGPS();
         CloseDGPS(); 

         // reset message counters and clear top of menu out  
         reset_count();           
         clear_count(); 
         menu_on = 0;
         display_replay_menu(); 
         show_count();       
      }
      break;
    
   case 20:                // T
      if ((kb.shift & 0x08) == 0x08) {  // alt-T
        // prompt for changes to terminal data type 
        clear_message_line();
        tempchar[0] = ask_char("MODIFY TERMINAL DATA TYPE? (A)SCII / (B)INARY -> ",'B',&valid);
        clear_message_line();  
        if(!valid) break;           
        switch( toupper(tempchar[0]) ){
          case 'A':
          	TermDataType = ASCII;
          	break;
          case 'B':
          	TermDataType = BINARY;
          	break;
          default:
            break;
        } // end switch
        break;    
      } // end alt-T
      
      TERMINAL ^= 1;
      if(TERMINAL){
        if((DataType == Z_NMEA) || (DataType == NC_NMEA)){
          TermDataType = ASCII;
        }
        else{
          TermDataType = BINARY;
        }
      }
      clear_screen();
      break; 
   case 21:                // Y
   case 22:                // U
      break;   
   case 23:                // I
      if ((kb.shift & 0x08) == 0x08) {  // alt-I

        CloseGPS();

        clear_message_line();  
        tgpsirq = gpsirq;
        tgpsirq  = ask_short("IRQ (0-15 CAUTION:  ENSURE THERE ARE NO IRQ CONFLICTS) -> ", tgpsirq, &valid); 
        clear_message_line();
        if( !valid ) break;

        if(IsIrqAvail(tgpsirq)){
          gpsirq = tgpsirq;
        }
        else {
          sprintf(buff,"IRQ %d IS IN USE BY ANOTHER DEVICE.  SETTING UNCHANGED",tgpsirq); 
          _outtext(buff);       
          break;
        }
        
        // save the new ini file data
        save_ini();
      
        open_gps  = 1; 
        
        // prompt for changes to RTCM-104 port 
        clear_message_line();
        tempchar[0] = ask_char("MODIFY RTCM IRQ SETTINGS? (Y,N) -> ",'N',&valid);
        clear_message_line();  
        if(!valid) break;           
        if(toupper(tempchar[0]) == 'N') break;

        CloseDGPS();
 
        clear_message_line();  
        tdifirq = difirq;
        tdifirq  = ask_short("IRQ (0-15 CAUTION:  ENSURE THERE ARE NO IRQ CONFLICTS) -> ", tdifirq, &valid); 
        clear_message_line();
        if(!valid) break;

        if(IsIrqAvail(tdifirq)){
          difirq = tdifirq;
        }
        else {
          sprintf(buff,"IRQ %d IS IN USE BY ANOTHER DEVICE.  SETTING UNCHANGED",tdifirq); 
          _outtext(buff);       
          break;
        }

        // save the new ini file data
        save_ini();
      
        open_dgps  = 1; 
      }
   case 24:                // O
   
      break;
   
   
   case 25:     // P space, play/pause playback   
      pause ^= 1;          // toggle run or restart
/****** capability disabled for this version
      // playback   
      if(!plyfileopen){
         clear_message_line(); 
         sprintf(buff,"GPS DATA PLAYBACK FILE NOT OPEN %s",gpsplyfile); 
         _outtext(buff); 
      }
      else{        
         // play recorded data 
         playback = 1; 
         pause = 1;
         save  = 0; // needed?
         save2 = 0;
         CloseGPS();
         CloseDGPS();   
         
         // reset message counters 
         reset_count();
      }
******/
      break; 
                   
   case 28:   // enter 
      break;                  

   case 31:                // S or s  

      switch(kb.shift & 0x0C){
        case 0x04: // cntl
          memset(&ZMsg.Msg1380, 0, sizeof(ZMsg.Msg1380));  
          ZMsg.Msg1380.RequestFlag = TRUE;
          BldZMsg(&ZMsgBuf, ZMsg, 1380);  
          memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1380) + HDR_LEN); 
          Cnt1380++;
          send_msg(tx_buff);  
          break;
        case 0x08: // alt
          get_send_file();
          Send_File();
          break;
        case 0x0C: // cntl-alt
          if(OpenRFBFile()) break;         // break if cannot open file 
          memset(&ZMsg.Msg1380, 0, sizeof(ZMsg.Msg1380));  
          ZMsg.Msg1380.RequestFlag = TRUE;
          BldZMsg(&ZMsgBuf, ZMsg, 1380);  
          memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1380) + HDR_LEN);
          reset_count(); reset_dtime(); clear_count();
          menu_on = 0; show_count();           
          FlashMode = 1;
		  temprate = gpsbaud; tempprty = gpsprty; 
		  tempnbit = gpsnbit; tempsbit = gpssbit;           
          gpsbaud = 9600; gpsprty = 'N';
          gpsnbit = 8; gpssbit = 1;
          ChangeBaud();
          FlushGPS();
          rec_cnt   = 0;
          data_len  = 10;
          have_sync = 0;
          _fmemset(rx_buff, 0, sizeof(rx_buff)); 
          _fmemset(msgbuff, 0, sizeof(msgbuff));
		  break;
        default:
          // single step replay 
          step ^= 1;
          break;     
      }
      break;  

   case 32:                // d 
      // toggle between normal and delta position
      delta ^= 1;    
      break;
      
   case 33:                // f
      if ((kb.shift & 0x08) == 0x08) {  // alt-F
         // load or store frequency standard data  
         if(!msg_support(Z_BINARY)) break;
         strcpy(frqtblfile, "frqdata.tbl"); 
         strcpy(frqparfile, "frqdata.par"); 
         StoreFrqTbl = 0;
         LoadFrqTbl  = 0;
         StoreFrqPar = 0;
         LoadFrqPar  = 0;

         clear_message_line();
         FrqStdDataType = 
            ask_short("FREQUENCY STANDARD DATA TYPE (0=PARAMETERS, 1=TABLE) -> ",
            0, &valid);
         clear_message_line();
         if(!valid) break;
         LoadStore = 
            ask_short("STORE OR LOAD FREQUENCY STANDARD DATA (0=STORE, 1=LOAD) -> ", 
            0, &valid);
         clear_message_line();
         if(!valid) break;                 
      
         if(FrqStdDataType){
            ask_str("TABLE DATA FILE (FILENAME.TBL) -> ", frqtblfile, &valid); 
         }
         else{
            ask_str("PARAMETER DATA FILE (FILENAME.PAR) -> ", frqparfile, &valid);
         }
         clear_message_line();
         if(!valid) break;                
      
         if(LoadStore & FrqStdDataType){    
            if((stream4 = _fsopen(frqtblfile, "rt", SH_DENYWR)) == NULL){
               sprintf(buff,"COULDN'T OPEN FILE %s!",frqtblfile); 
            }
            else{
               LoadFrqTbl = 1; 
               fclose(stream4); 
            }
         }
         else if(!LoadStore & FrqStdDataType){
            if((stream4 = _fsopen(frqtblfile, "at", SH_DENYWR)) == NULL){
               sprintf(buff,"COULDN'T OPEN FILE %s!",frqtblfile);
            }
            else{
                StoreFrqTbl = 1;
                fclose(stream4); 
            }
         } 
         else if(LoadStore & !FrqStdDataType){    
            if((stream5 = _fsopen(frqparfile, "rt", SH_DENYWR)) == NULL){
               sprintf(buff,"COULDN'T OPEN FILE %s!",frqparfile); 
            }
            else{
               LoadFrqPar = 1;
               fclose(stream5); 
            }
         }
         else if(!LoadStore & !FrqStdDataType){
            if((stream5 = _fsopen(frqparfile, "at", SH_DENYWR)) == NULL){
               sprintf(buff,"COULDN'T OPEN FILE %s!",frqparfile);
            }
            else{
               StoreFrqPar = 1;
               fclose(stream5);  
            }
         } 
         _outtext(buff);
         clear_message_line();
         if(!valid) break;
         if(FrqStdDataType){
            sprintf(buff,"TABLE DATA FILE IS %s", frqtblfile);
         }
         else{
            sprintf(buff,"PARAMETER DATA FILE IS %s",frqparfile);
         } 
         _outtext(buff); 
         wait(1.f);
      
         if(LoadFrqTbl){
            memset(&ZMsg.Msg1360, 0, sizeof(ZMsg.Msg1360));  
            BldZMsg(&ZMsgBuf, ZMsg, 1360);  
            memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1360) + HDR_LEN); 
            Cnt1360++;
            send_msg(tx_buff);  
         }
         else if(LoadFrqPar){    
            memset(&ZMsg.Msg1310, 0, sizeof(ZMsg.Msg1310));  
            BldZMsg(&ZMsgBuf, ZMsg, 1310);  
            memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1310) + HDR_LEN); 
            Cnt1310++;
            send_msg(tx_buff);        
         }
         else if(StoreFrqTbl){
            memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
            ZMsg.ZQuery.MsgID    = (tSHORT) 1160;
            ZMsg.ZQuery.MsgFlags = Q_BIT | ANREQ;
            BldZQuery(&ZMsgBuf, &ZMsg.ZQuery);  
            memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
            CntZQry++;   
            send_msg(tx_buff); 
         }      
         else if(StoreFrqPar){
            memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
            ZMsg.ZQuery.MsgID    = (tSHORT) 1110;
            ZMsg.ZQuery.MsgFlags = Q_BIT | ANREQ;
            BldZQuery(&ZMsgBuf, &ZMsg.ZQuery);  
            memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
            CntZQry++;   
            send_msg(tx_buff); 
         }
         break;
      }

      // prompt for filter values for data extraction
      clear_message_line(); 
      minsats = ask_short("MINIMUM SATS USED (0-12) -> ", minsats, &valid);
      clear_message_line();
      if(!valid) break;     
      
      if(DataType == NC_BINARY){
         maxhdop = ask_float("MAXIMUM HDOP (1-99) -> ", maxhdop, &valid);
         clear_message_line();
         if(!valid) break;
         maxpdop = ask_float("MAXIMUM PDOP (1-99) -> ", maxpdop, &valid);
         clear_message_line();
         if(!valid) break;
         maxvdop = ask_float("MAXIMUM VDOP (1-99) -> ", maxvdop, &valid);
         clear_message_line();
         if(!valid) break;
         minfom = ask_short("MINIMUM FOM (1-9) -> ", minfom, &valid);
         clear_message_line();
         if(!valid) break;
      }
      else if (DataType == Z_BINARY){
         StatMask = ask_hex("NAV STATUS MASK (0000-FFFF) -> ", StatMask, &valid);
         clear_message_line();
         if(!valid) break; 
      }
      else if((DataType == NC_NMEA) || (DataType == Z_NMEA)){
         maxhdop = ask_float("MAXIMUM HDOP (1-99) -> ", maxhdop, &valid);
         clear_message_line();
         if(!valid) break;
         minqual = ask_short("MINIMUM QUALITY  (0-1) -> ", minqual, &valid);
         clear_message_line(); 
         if(!valid) break;
      }     
      
      // save the filter parameters             
      save_cfg();
      break;
      
   case 34:                // g 
      if ((kb.shift & 0x08) == 0x08) {  // alt-G
         
        // store gyro temperature table  
        if(!msg_support(Z_BINARY)) break;

        if((stream4 = _fsopen("gyrodata.tbl", "at", SH_DENYWR)) == NULL){
          sprintf(buff,"COULDN'T OPEN FILE %s!","gyrodata.tbl");
        } else {
          sprintf(buff,"GYRO TEMPURATURE TABLE DATA FILE IS %s", "gyrodata.tbl");
          memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
          ZMsg.ZQuery.MsgID    = (tSHORT) 1072;
          ZMsg.ZQuery.MsgFlags = Q_BIT | ANREQ;
          BldZQuery(&ZMsgBuf, &ZMsg.ZQuery);  
          memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
          CntZQry++;   
          send_msg(tx_buff); 
        }
         
         _outtext(buff);
         fclose(stream4);
         break;
      }

      if (!((kb.shift & 0x0C) == 0x0C)) break;
      if(!msg_support(Z_BINARY)) break; // break if not Z_BINARY
      if((Send_FilePtr = _fsopen("GM01.INI", "rb", SH_DENYWR)) == NULL){
         clear_message_line();
         _outtext("COULDN'T OPEN GM01.INI!\7");
         break;
      }
      Send_File();
      wait(1.5f);
      gpsbaud = 4800;
      clear_screen();
      _settextposition(cmdline, 1);
      if(OpenGPS(gpsport, gpsirq, gpsbaud, gpsprty, gpsnbit, gpssbit)==0){;
         sprintf(buff,"GPS PORT: COM%1d IRQ%2d LOC %3X ",
                      gpscom, gpsirq, gpsport);
         _outtext(buff);  
         open_gps = 0;
      }
      else{
         sprintf(buff,"GPS PORT: COM%1d IRQ%2d LOC %3X NOT FOUND ",
                       gpscom, gpsirq, gpsport);
         _outtext(buff);
      }
      DataType = Z_NMEA;
      rewind(Send_FilePtr);
      Send_File();
      wait(1.5f);
      rewind(Send_FilePtr);
      Send_File();
      FlushGPS();
      wait(1.f);
      fclose(Send_FilePtr);  // close binary file    
      save_ini();
      save_cfg();
      clear_screen();
      reset_dtime();
      clear_message_line();
      _outtext("RECEIVER INITIALIZED!"); 
      clear_count();
      if(!menu_on){
         // clear top of menu out 
         show_count(); 
      }
      else{
         display_menus(&current_menu);
      }
      break;
   
   case 35:                // h 
   case 36:                // j  
   case 37:                // k 
   case 38:                // L  
      break;        
   case 45:                // x
   
      // open file and toggle extraction 
      if(extfileopen){
         // toggle extraction 
         xtract ^= 1;
      }
      else{
         if (DataType == Z_BINARY)   
          do{
             clear_message_line();
             ask_str("MESSAGE ID (LLA, PV, COV, RNG, SVD) -> ", xtractid, &valid);
             clear_message_line();
             if(!valid) break;
             _strupr(xtractid);
             if(strcmp(xtractid,"LLA") != 0 &&
                strcmp(xtractid,"PV" ) != 0 &&
                strcmp(xtractid,"COV") != 0 &&
                strcmp(xtractid,"RNG") != 0 &&
                strcmp(xtractid,"SVD") != 0   ){
                clear_message_line();
                _outtext("INVALID XTRACT DATA ID!"); 
                strcpy(xtractid, " ");
                wait(1.5f);
                valid = 0;
                continue;
             }
          }   
          while(xtractid == " ");
         else
          valid = 1;
          
          if(!valid) break;
          if(strcmp(xtractid,"LLA") == 0){
             do{
                clear_message_line();
                ask_str("REMOVE LAT AND LON SIGN FOR PLOTTING ( Y, N ) -> ", YN_LLASIGN, &valid);
                clear_message_line();
                if(!valid) break;
                _strupr(YN_LLASIGN);
                if(strcmp(YN_LLASIGN,"Y") != 0 &&
                   strcmp(YN_LLASIGN,"N") != 0   ){
                   clear_message_line();
                   _outtext("INVALID RESPONSE!"); 
                   strcpy(YN_LLASIGN, " ");
                   wait(1.5f);
                   valid = 0;
                   continue;
                }
             }   
             while(YN_LLASIGN == " ");
          }
          
          if(strcmp(xtractid,"RNG") == 0){
             do{
                clear_message_line();
                xtractchannel = 1;
                xtractchannel = ask_short("CP PR RR of channel to be extracted (1 - 12, 13 for all) -> ",
                				 xtractchannel, &valid);
                clear_message_line();
                if(!valid) break;
                if(xtractchannel < 1 || xtractchannel > 13   ){
                   clear_message_line();
                   _outtext("INVALID RESPONSE!"); 
                   xtractchannel = 0;
                   wait(1.5f);
                   valid = 0;
                   continue;
                }
             }   
             while(xtractchannel == 0);
          }
          
          if(!valid) break; 
          if(strcmp(YN_LLASIGN,"Y") == 0) ABS_LLA = TRUE;
          if(strcmp(YN_LLASIGN,"N") == 0) ABS_LLA = FALSE;
          
          if(!valid) break;
          if(strcmp(xtractid,"SVD") == 0){ 
             do{
                clear_message_line();
                ask_str("DATA EXTRACTION TYPE (EPH, ALM, UTC, ALL) -> ", dxt, &valid);
                clear_message_line();
                if(!valid) break;
                _strupr(dxt);
                if(strcmp(dxt,"EPH") != 0 &&
                   strcmp(dxt,"ALM") != 0 &&
                   strcmp(dxt,"UTC") != 0 &&
                   strcmp(dxt,"ALL") != 0   ){
                   clear_message_line();
                   _outtext("INVALID RESPONSE!"); 
                   strcpy(dxt, " ");
                   wait(1.5f);
                   valid = 0;
                   continue;
                }
             }   
             while(dxt == " ");

             if(!valid) break; 
             do{
                clear_message_line();
                ask_str("Would you like to use Fast Extract (Y, N) -> ", YN_FXTRACT, &valid);
                clear_message_line();
                if(!valid) break;
                _strupr(YN_FXTRACT);
                if(strcmp(YN_FXTRACT,"Y") != 0 &&
                   strcmp(YN_FXTRACT,"N" ) != 0   ){
                   clear_message_line();
                   _outtext("INVALID RESPONSE!"); 
                   strcpy(YN_FXTRACT, " ");
                   wait(1.5f);
                   valid = 0;
                   continue;    
                }
             }   
             while(YN_FXTRACT == " ");

             if(!valid) break; 
             if(strcmp(YN_FXTRACT,"Y") == 0) fxtract = 1;
             if( (strcmp(dxt,"EPH") == 0) || (strcmp(dxt,"ALL") == 0) ){
                COLLECT_EPH = TRUE;  //set flag to extract ephemeris data
                if((stream6 = fopen("eph.tmp", "w+b")) == NULL){
                   sprintf(buff,"COULDN'T OPEN FILE %s!","eph.tmp"); 
                   clear_message_line;
                   _outtext(buff); 
                   valid = 0;
                }
             }
             if( (strcmp(dxt,"ALM") == 0) || (strcmp(dxt,"ALL") == 0) ){
                COLLECT_ALM = TRUE;  //set flag to extract almanac data
                if((stream7 = fopen("alm.tmp", "w+b")) == NULL){
                   sprintf(buff,"COULDN'T OPEN FILE %s!","alm.tmp"); 
                   clear_message_line;
                   _outtext(buff);
                   valid = 0;
                }
                if((stream8 = fopen("rawalm.tmp", "w+b")) == NULL){
                   sprintf(buff,"COULDN'T OPEN FILE %s!","almanac.dat"); 
                   clear_message_line;
                   _outtext(buff);
                   valid = 0;
                }
                if((almdata = _fsopen("almanac.dat", "wt", SH_DENYWR)) == NULL){
                   sprintf(buff,"COULDN'T OPEN FILE %s!","almanac.dat"); 
                  _outtext(buff); 
                   valid = 0;
                }
             }   
             if( (strcmp(dxt,"UTC") == 0) || (strcmp(dxt,"ALL") == 0) ) COLLECT_UTC = TRUE;  //set flag to extract utc data
          }  // end svd extra stuff
          
          xtract = 1;
          strcpy(gpsextfile, xtractid); 
          i = strlen(xtractid);         
          gpsextfile[i    ] = '.';    
          gpsextfile[i + 1] = 'T';
          gpsextfile[i + 2] = 'X';
          gpsextfile[i + 3] = 'T';    
          gpsextfile[i + 4] = '\0';     
          
          clear_message_line();
          ask_str("XTRACT DESTINATION FILE (FILENAME.TXT) -> ", gpsextfile, &valid);
          clear_message_line();
          if((stream3 = _fsopen(gpsextfile, "wt", SH_DENYWR)) == NULL){
             sprintf(buff,"COULDN'T OPEN FILE %s!",gpsextfile); 
             _outtext(buff); 
             valid = 0;
          }
          else{ 
             // extract recorded data 
             sprintf(buff,"XTRACT DESTINATION FILE IS %s",gpsextfile); 
             _outtext(buff); 
             wait(1.f);
             if(strcmp(xtractid,"COV") == 0){
               fprintf(stream3, "%16s %9s %9s %10s %10s %10s %10s \n",
                       "        GPS Time","     EHPE","     EVPE","  UTC Date","  UTC Time",
                       "  Set Time","  Nav Mode");      
             }
             if(strcmp(xtractid,"LLA") == 0){
               fprintf(stream3, "%16s %11s %11s %9s %10s %11s %9s\r\n",
                       "        GPS Time"," Longitude","   Latitude"," Altitude",
                       " Delta Lon","  Delta Lat","Delta Alt");      
             }
             if(strcmp(xtractid,"RNG") == 0){
               fprintf(stream3, "%16s %2s %2s %4s %12s %12s %9s\r\n",
                       "        GPS Time","CH","SV","STAT","CarrierPhase","Pseudo Range"," RangRate");      
             }
             extfileopen = 1;
             pause = 0; 
             CntNav = 0;
             CntPnt = 0;
          } 
          if(!valid) break; 
      }   
      show_xtract(xtract);
      break;
    
   case 46:     // 'C' clear screen

      clear_screen();
      break;     
                
   case 47:                // V or v    
      // alt-V. Save vEEPROM to File on PC.
      if ((kb.shift & 0x08) == 0x08) 
      {  
         // Open Data File.
         // Validate that file can be opened.  
         if ((vEEPROMFilePtr = fopen("veeprom.dat","wb")) == NULL)
         {
            sprintf(buff,"COULDN'T OPEN FILE %s!","veeprom.dat "); 
            clear_message_line;
            _outtext(buff); 
         }
         else
         {            
            // Allow for different sizes of vEEPROMs. 
            // Initial word is the size of the vEEPROM.
            c = (char)(VEEPROM_NUM_WORDS & 0x00FF);
            fputc(c, vEEPROMFilePtr);
            c = (char)((VEEPROM_NUM_WORDS & 0xFF00) >> 8);
            fputc(c, vEEPROMFilePtr);

            // Copy number of VEEPROM words to file.
            for (i=0; i<VEEPROM_NUM_WORDS; i++) 
            {
               c = (char)(TempStore[i] & 0x00FF);
               fputc(c, vEEPROMFilePtr);
               c = (char)((TempStore[i] & 0xFF00) >> 8);
               fputc(c, vEEPROMFilePtr);
            }

            // Terminate file.
            fputc(EOF, vEEPROMFilePtr);

            // Close file.
            fclose(vEEPROMFilePtr);
         }
      }
      break;         
      
         
   case 49:                // N or n    
   
      // toggle between menu and additional data
      menu_on ^= 1; 
      if(!menu_on){
         // clear top of menu out 
         clear_count();
         show_count(); 
      }
      else{
         if(playback){
            display_replay_menu();
         }
         else{       
            display_menus(&current_menu);
         }
      }
      break; 

   case 50:                // M or m  
   
      current_menu++;
      if(!playback){
         display_menus(&current_menu);
      }
      else{
         display_replay_menu();
      }
      break;           

   case 51:     // , or < key, shift not needed to use key as <
         // single step backward during replay  
         pause = 0;
         step = 1;
       
         // move back a record in the circular file position buffer
         nfpos -= 2;     
         if(nfpos < 1) nfpos += max_fpos;;
         pos = fpos[nfpos]; 
         
         if(pos != 0 && fsetpos(stream, &pos) == 0){ 
         
            // reset sync and counter variables   
            if((DataType == NC_NMEA) || (DataType == Z_NMEA)){
               // nmea
               rec_cnt  = 0;
               have_sync = 0; 
               cr_found  = 0;
               ast_found = 0;  
               pause = 0;
               _fmemset(msgbuff, ' ', sizeof(msgbuff));  
               _fmemset(nmea_msg, ' ', 80); 
            }
            else if ((DataType == NC_BINARY) || (DataType == Z_BINARY)){
               // binary
               rec_cnt   = 0;
               data_len  = 10;
               have_sync = 0;  
               pause     = 0;
            }
         }
         break;  
           
   case 52:     // . or > key, shift not needed to use key as >
      // single step forward during replay  
      pause = 0;
      step = 1;
      break;     
        
   case 57:     // space bar
      // play/pause playback
      pause ^= 1;      
      step = 0;
      break;         

   case 72:     // Up arrow       
      break;

   case 80:     // Dn arrow                                            
      break;

   case 82:     // Ins, record data
/****** capability disabled for this version
       if(playback){             
  
         // close playback file and stop playing
         if(plyfileopen){
            clear_message_line();  
            sprintf(buff,"CLOSING GPS PLAYBACK FILE %s",gpsplyfile); 
            _outtext(buff); cputs("\a\a");       
            fclose(stream);
         } 
         playback = 0;   
         open_gps = 1;
         break;
      }
   
      // check for an open port
      if(!gps_open && !dgps_open){
          clear_message_line(); 
          sprintf(buff,"NO GPS OR RTCM PORT OPEN FOR RECORDING!"); 
          _outtext(buff); cputs("\a");                                 
          break;
      }                                
      else{
         // generate file names
         _strdate(tempchar);
         gpsrecfile[0]  = tempchar[0];    
         gpsrecfile[1]  = tempchar[1];
         gpsrecfile[2]  = tempchar[3];
         gpsrecfile[3]  = tempchar[4];
         gpsrecfile[4]  = tempchar[6];
         gpsrecfile[5]  = tempchar[7];  
         gpsrecfile[6]  = (char) gpsrecfilen++;  
         gpsrecfile[7]  = '.';    
         gpsrecfile[8]  = 'd';
         gpsrecfile[9]  = 'a';
         gpsrecfile[10] = 't';     
         strcpy(difrecfile, gpsrecfile);
         difrecfile[8]  = 'r';
         difrecfile[9]  = 't';
         difrecfile[10] = 'c';     
      }
       
      // check for open gps port
      if(gps_open){
         clear_message_line();  
         ask_str("GPS DATA RECORD FILE -> ", gpsrecfile, &valid); 
         clear_message_line(); 
         if(!valid) break;    
         fclose(stream);                                   
       
         if((stream = _fsopen(gpsrecfile, "wb", SH_DENYWR)) == NULL){
            sprintf(buff,"COULDN'T OPEN FILE %s!",gpsrecfile); 
            _outtext(buff);     
            save = 0;
         }
         else{
            sprintf(buff,"GPS DATA RECORD FILE IS %s",gpsrecfile); 
            _outtext(buff);
            gpsfileopen = 1; 
            gpsrecord = 0;          
         }                                                      
      }
    
      // check for open rtcm port
      if(dgps_open){
         clear_message_line(); 
         ask_str("RTCM DATA RECORD FILE -> ", difrecfile, &valid); 
         clear_message_line(); 
         if(!valid) break;   
         fclose(stream2);
         if((stream2 = _fsopen(difrecfile, "wb", SH_DENYWR)) == NULL){
            sprintf(buff,"COULDN'T OPEN FILE %s!",difrecfile); 
            _outtext(buff);  
            save2 = 0;
         }
         else{
            sprintf(buff,"RTCM DATA RECORD FILE IS %s",difrecfile); 
            _outtext(buff);
            diffileopen = 1; 
            difrecord = 0;          
         }
      }                                                      
******/
      break;
          
   case 83:     // Del
      break; 

   case 73:     // PgUp                                 
      break;                          
      
   case 81:     // PgDn, normal monitor mode
/****** capability disabled for this version
      // reset message counters 
      reset_count();

      if(playback){  
  
         // close playback file and stop playing
         if(plyfileopen){
            clear_message_line();  
            sprintf(buff,"CLOSING GPS PLAYBACK FILE %s",gpsplyfile); 
            _outtext(buff); cputs("\a\a");       
            fclose(stream);
            plyfileopen = 0;
         } 
         playback = 0;   
         open_gps = 1;
         break;
      }
      
      // close RTCM file and stop recording
      if(diffileopen){ 
         save2 = 0;     
         difrecord = 0;
         clear_message_line();  
         sprintf(buff,"CLOSING RTCM DATA FILE %s",difrecfile); 
         _outtext(buff); cputs("\a\a");       
         fclose(stream);  
         diffileopen = 0;
      }
       
      // close a file and stop recording
      if(gpsfileopen){  
         save = 0;      
         gpsrecord = 0;
         clear_message_line();  
         sprintf(buff,"CLOSING GPS DATA FILE %s",gpsrecfile); 
         _outtext(buff); cputs("\a\a");       
         fclose(stream);
         gpsfileopen = 0;
      }
******/
      break;

   case F1:
      init_time(); 
      
      // save the config file
      save_cfg();
      break;

   case F2:
      init_pos_vel();
      break;

   case F3: 
      init_height(); 
      break;

   case F4:
      // user defined datum
      if(!msg_support(Z_BINARY)) break;       
      clear_message_line();  
      datum = ask_short("USER DEFINED DATUM NUMBER (300-304) -> ", datum, &valid);
      clear_message_line();   
      if(!valid) break;     
      SemiMajorAxis = ask_dbl("SEMI-MAJOR AXIS (M) -> ", 6.3E+06, &valid);
      clear_message_line();   
      if(!valid) break;
      InverseFlattening = ask_dbl("INVERSE FLATTENING (280-320) -> ", 300, &valid);
      clear_message_line();   
      if(!valid) break;
      WGS84OffsetdX = ask_dbl("WGS-84 OFFSET DX (M) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;
      WGS84OffsetdY = ask_dbl("WGS-84 OFFSET DY (M) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;
      WGS84OffsetdZ = ask_dbl("WGS-84 OFFSET DZ (M) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;
       
      // build message 
      memset(&ZMsg.Msg1210, 0, sizeof(ZMsg.Msg1210));            
      ZMsg.Msg1210.DatumID = (tUSHORT) datum;
      ZMsg.Msg1210.SemiMajorAxisInt      = (tULONG)  SemiMajorAxis;
      ZMsg.Msg1210.SemiMajorAxisFrac     = (tUSHORT)
          ((SemiMajorAxis - ZMsg.Msg1210.SemiMajorAxisInt) * 1E+04);
      ZMsg.Msg1210.InverseFlatteningInt  = (tUSHORT) InverseFlattening;
      ZMsg.Msg1210.InverseFlatteningFrac = (tULONG) 
          ((InverseFlattening - ZMsg.Msg1210.InverseFlatteningInt) * 1E+09); 
      ZMsg.Msg1210.WGS84OffsetdX = (tLONG) (WGS84OffsetdX * 1E+02);
      ZMsg.Msg1210.WGS84OffsetdY = (tLONG) (WGS84OffsetdY * 1E+02);
      ZMsg.Msg1210.WGS84OffsetdZ = (tLONG) (WGS84OffsetdZ * 1E+02); 
      BldZMsg(&ZMsgBuf, ZMsg, 1210);
      memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1210) + HDR_LEN); 
      Cnt1210++;
      send_msg(tx_buff);       
      break;

   case F5: 
      if(!msg_support(Z_BINARY)) break;       
//      init_timemark(); 
      break;

   case F6: // Factory Test Mode for Limited Use
      if(!msg_support(Z_BINARY + Z_NMEA)) break;  
        if (DataType == Z_BINARY){

          memset(&ZMsg.Msg1304, 0, sizeof(ZMsg.Msg1304));
          BldZMsg(&ZMsgBuf, ZMsg, 1304);
          memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1304) + HDR_LEN);
          Cnt1304++;
          send_msg(tx_buff);
        }
        else if (DataType == Z_NMEA){
          sprintf(tx_buff,"$PRWIFTST,RES,FTST");
          cntftst++;
          send_nmea_msg(tx_buff);
        }
      break;

   case F7:  
      if(!msg_support(Z_BINARY)) break;  
      init_dr();
      break;

   case F8:   
      if(!msg_support(NC_BINARY + Z_BINARY + Z_NMEA)) break;  
      menu_on = 1;
      BIT_tests();
      break;

   case F9: 
      if(!msg_support(Z_BINARY + Z_NMEA)) break;  
      if (DataType == Z_BINARY){

        clear_message_line();
        GyroBias = 0;  
        GyroBias = ask_short("0 = Gyro Bias Cal., 1 = Gyro SCale Factor Cal. -> ",
        					 GyroBias, &valid);
        clear_message_line();   

        if (GyroBias > 1 || GyroBias < 0) {
          clear_message_line();
          sprintf(buff,"Invalid Gyro Cal. mode %d", GyroBias); 
          _outtext(buff); cputs("\a\a");
          break;       
        }
        // build message 
        memset(&ZMsg.Msg1305, 0, sizeof(ZMsg.Msg1305));            
        ZMsg.Msg1305.DRFactoryTestFlag = (tUSHORT) ( 1 + 2 * GyroBias);
        BldZMsg(&ZMsgBuf, ZMsg, 1305);
        memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1305) + HDR_LEN);
        Cnt1305++;
        send_msg(tx_buff);
      }
      break;
   
   case F10: 
      // navcore oscillator offset  
      if(!msg_support(Z_BINARY)) break; 
      
      clear_message_line();
      ask_str("enter character string send to receiver -> ", buff, &valid);
      clear_message_line();
      _outtext(buff);
	  for(i=0;i<80;i++){
	    if (buff[i] == '\0') {
//	      sprintf(buff," '%s' sent!",buff
//          _outtext("RESTARTING RECEIVER");
	      break;
	    }
		send_byte(buff[i]);
	  } 

      break;
   case 133:           // F11       
      // reset receiver
      if (ResetReceiver(0)){
         reset_dtime();
         if(!menu_on){
            clear_count();
         }
         clear_screen();
         clear_message_line(); 
         _outtext("RESTARTING RECEIVER");
      }       
      FlushGPS();
      wait(1.f);
      rec_cnt    = 0;
      data_len   = 10;
      have_sync  = 0; 
      vEEPBlockBitMap = 0;
      vEEPAvailable   = FALSE;
// BELONG TO TEST CODE FOR RESETTING RECEIVER      ReSet = TRUE;
      break;     
      
      
   case 134:            // F12       
      // reset message counters, reference time and refresh 
      reset_dtime();
      reset_count();  
        
      // clear top of menu out 
      clear_count();
      menu_on = 0;   
      show_count(); 
      break;
     
   case sF1:
      // Receiver port control
      //  
      if(!msg_support(NC_NMEA + NC_BINARY + Z_BINARY)) break; 

      if ((DataType == NC_BINARY) || (DataType == NC_NMEA))
      {
         NSetSerialComm();
      }
      else if ((DataType == Z_BINARY))
      {
         ZSetSerialComm();
      }
      break;   

   case sF2:           
      // set receiver message protocol

      if(!msg_support(Z_BINARY+Z_NMEA)) break;  // only supported by Zodiac

      clear_message_line();

      if (DataType == Z_BINARY){  // current mode is binary

/**** currently not enabled in Zodiac SW *****

         ProtocolType = ask_short("PROTOCOL TYPE (1=NMEA-183, 2=RTCM SC-104) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         DataStream = ask_short("DATA STREAM (0=HOST, 1=AUX) -> ", 0, &valid);
         clear_message_line(); 
         if(!valid || (DataStream != 0 && DataStream != 1)) break;

***** currently not enabled in Zodiac SW ****/

         DataStream   = 0;  // will be ignored
         ProtocolType = 1;  // force NMEA

         memset(&ZMsg.Msg1331, 0, sizeof(ZMsg.Msg1331));            
         ZMsg.Msg1331.Stream   = (tUSHORT) DataStream;
         ZMsg.Msg1331.Protocol = (tUSHORT) ProtocolType;
         BldZMsg(&ZMsgBuf, ZMsg, 1331);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1331) + HDR_LEN); 
         Cnt1331++;
         send_msg(tx_buff);
      }

      else if (DataType == Z_NMEA){  // current mode is NMEA

/**** currently not enabled in Zodiac SW *****

         ProtocolType = ask_short("PROTOCOL TYPE (0=BINARY, 2=RTCM SC-104) -> ", 0, &valid);
         clear_message_line();
         if (!valid) break;

         DataStream = ask_short("DATA STREAM (0=HOST, 1=AUX) -> ", 0, &valid);
         clear_message_line(); 
         if (!valid || (DataStream != 0 && DataStream != 1)) break;

***** currently not enabled in Zodiac SW ****/

         DataStream   = 0;  // will be ignored
         ProtocolType = 0;  // force binary

         if (ProtocolType == 1){
            sprintf(nmea_msg, "$PRWIIPRO,%d,NMEA", DataStream);
         }
         else if(ProtocolType == 2){
            sprintf(nmea_msg, "$PRWIIPRO,%d,RTCM", DataStream);
         }
         else{
            sprintf(nmea_msg, "$PRWIIPRO,%d,RBIN", DataStream);
         }
         cntipro++;
         send_nmea_msg(nmea_msg);
         wait(1.5f);
      }

      clear_message_line();
      switch (ProtocolType) {

         case 0:
            _outtext("RECEIVER MESSAGE PROTOCOL SET TO ZODIAC BINARY");
            break;

         case 1:
            _outtext("RECEIVER MESSAGE PROTOCOL SET TO ZODIAC NMEA-0183");
            break;
      }
      break;
      
   case sF3:         
      // log control 

      if(!msg_support(NC_NMEA+Z_BINARY+Z_NMEA)) break;  // no NavCore binary support

      if(DataType == NC_NMEA){
         send_nmea_log();
         wait(1.5f);
      }
      else if(DataType == Z_NMEA){
         send_nmea_ilog();
         wait(1.5f);
      }
      else if(DataType == Z_BINARY){
         MsgFlags = 0;
         clear_message_line();  

         MsgID = ask_short("MESSAGE ID (XXXX, 65535 DISABLES ALL, 0 ENTER BY FIELD NAME) -> ", 0, &valid);
         clear_message_line();  
         if(!valid) return;
         
         if((MsgID == 0) && (DataType == Z_BINARY)) MsgID = get_msgid_from_field_name();
         clear_message_line();  
         if(!valid) return;
         
         tempchar[0] = ask_char("LOG (C=CONNECT, D=DISCONNECT, N=NO CHANGE) -> ", 'N', &valid);
         clear_message_line();  
         if(!valid) return;     
         if(toupper(tempchar[0]) == 'C'){
            MsgFlags |= C_BIT;  // connect
         }
         else if(toupper(tempchar[0]) == 'D'){
            MsgFlags |= D_BIT;  // disconnect
         }

         tempchar[0] = ask_char("MODIFY TIMING? (Y,N) -> ", 'Y', &valid);
         clear_message_line();  
         if(!valid) return;     
         if(toupper(tempchar[0]) == 'Y'){
            MsgFlags |= L_BIT;  // log control
            tempchar[0] = ask_char("MESSAGE TRIGGER (T=TIME, U=UPDATE) -> ", 'T', &valid);
            clear_message_line();
            if(!valid) return;

            if (toupper(tempchar[0]) == 'T') {
               MsgTrigger = 0;
               MsgInterval = ask_short("MESSAGE INTERVAL (SECS) -> ", 1, &valid);
               clear_message_line();
               if(!valid) return;
               MsgOffset = ask_short("MESSAGE OFFSET (SECS) -> ", 0, &valid);
               clear_message_line();
               if(!valid) return;
            }
            else if (toupper(tempchar[0]) == 'U') {
               MsgTrigger  = 1;
               MsgInterval = 0;  // on update, these should be zero
               MsgOffset   = 0;
            }
            else return;  // invalid trigger specified
         }
         else{
            MsgTrigger  = 0;
            MsgInterval = 0;
            MsgOffset   = 0;
         }

         if(MsgFlags != 0){
            MsgFlags |= ANREQ;  // request ack/nak response

            if((MsgFlags & L_BIT) != 0){
               // build a log message
               memset(&ZMsg.ZLog, 0, sizeof(ZMsg.ZLog));
               ZMsg.ZLog.MsgID       = (tSHORT) MsgID;
               ZMsg.ZLog.MsgFlags    = (tSHORT) MsgFlags;
               ZMsg.ZLog.MsgTrigger  = (tSHORT) MsgTrigger;
               ZMsg.ZLog.MsgInterval = (tSHORT) MsgInterval;
               ZMsg.ZLog.MsgOffset   = (tSHORT) MsgOffset;
               BldZLog(&ZMsgBuf, &ZMsg.ZLog);
               memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZLog) + HDR_LEN);
             }
            else{  
               // connect/disconnect only has no data, like query
               memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
               ZMsg.ZQuery.MsgID       = (tSHORT) MsgID;
               ZMsg.ZQuery.MsgFlags    = (tSHORT) MsgFlags;
               BldZQuery(&ZMsgBuf, &ZMsg.ZQuery);
               memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
            }
            CntZLog++;
            if(TERMINAL) clear_screen();
            send_msg(tx_buff);
            wait(1.5f);
         }
      }
      break;
      
   case sF4:         
      // query message 

      if(!msg_support(NC_NMEA+Z_BINARY+Z_NMEA)) break;  // no NavCore binary support

      if((DataType == NC_NMEA) || (DataType == Z_NMEA)){
         send_nmea_q();
      }
      else if(DataType == Z_BINARY){
         clear_message_line();
         MsgID = ask_short("MESSAGE ID TO QUERY (XXXX) -> ", 0, &valid);
         clear_message_line();  
         if(!valid) return;

         memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
         ZMsg.ZQuery.MsgID    = (tSHORT) MsgID;
         ZMsg.ZQuery.MsgFlags = Q_BIT | ANREQ;
         BldZQuery(&ZMsgBuf, &ZMsg.ZQuery);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
         CntZQry++;
         if(TERMINAL) clear_screen();
         send_msg(tx_buff); 
      } 
      wait(1.5f); 
      break;

   case sF5:
      // send generic nmea message 
      if(!msg_support(NC_NMEA+Z_NMEA)) break;
      send_nmea_gen();
      wait(1.5f);
      break;

   case sF6: 
      // request typical messages used for evaluation
      if(!msg_support(NC_NMEA+Z_NMEA)) break;
      if(DataType == Z_NMEA){
         send_nmea_ityp();  
      }
      else if(DataType == NC_NMEA){
         send_nmea_typ();      
      }
      wait(1.5f);
      break;

   case sF7:
      // Send a file to the serial port (gpsport)
      if(!msg_support(Z_BINARY)) break; // break if not Z_BINARY
      if(get_send_file()) break;        // break if send file not open
      Send_File();
      fclose(Send_FilePtr);  // close binary file    
      break;

   case sF8:
      // request age of and then almanac dump
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      if(DataType == NC_BINARY){
        alm_age_req();
      }
      else if(DataType == Z_BINARY){
        alm_request();
        utc_request();
      }  
      break;       
      
   case sF9:   
      // request raw or corrected Pseudoranges
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      clear_message_line();
      
      // get input parameters 
      PrReq = ask_short("ENABLE PSEUDORANGE OUTPUT (0=NO, 1=YES) -> ", 1, &valid);
      clear_message_line();  
      if(!valid) return; 
       
      if(DataType == NC_BINARY){
         PrClkCorr = ask_short("ENABLE SATELLITE CLOCK "
                                  "CORRECTIONS (0=NO, 1=YES) -> ", 1, &valid); 
         clear_message_line();  
         if(!valid) return;  
         PrTropCorr = ask_short("ENABLE TROPOSPHERIC AND IONOSPHERIC "
                                "CORRECTIONS (0=NO, 1=YES) -> ", 1, &valid);
         clear_message_line();  
         if(!valid) return;  
         PrDgpsCorr = ask_short("ENABLE DGPS "
                                "CORRECTIONS (0=NO, 1=YES) -> ", 1, &valid);
         clear_message_line();  
         if(!valid) return;  
       
         make_tx_header(213, 13);
         *(unsigned short *)(tx_buff+10) = 111;
         *(unsigned short *)(tx_buff+12) = 0x04 | PrReq; 
         *(unsigned long  *)(tx_buff+14) = (long) PrReq;
         *(unsigned short *)(tx_buff+18) = (PrDgpsCorr << 10) | // DGPS
                                           (PrTropCorr <<  9) | // tropo/iono
                                           (PrClkCorr  <<  8);  // sat clock 
         cnt213++;
         send_msg(tx_buff);
      }
      else if(DataType == Z_BINARY){
         MsgID       = 1007;
         MsgFlags    = L_BIT | ANREQ; 
         MsgTrigger  = 0;
         MsgInterval = 1;
         MsgOffset   = 0;
 
         if(PrReq){
            MsgFlags |= C_BIT;  // connect
         }
         else{
            MsgFlags |= D_BIT;  // disconnect
         }

         // build a log message
         memset(&ZMsg.ZLog, 0, sizeof(ZMsg.ZLog));
         ZMsg.ZLog.MsgID       = (tSHORT) MsgID;
         ZMsg.ZLog.MsgFlags    = (tSHORT) MsgFlags;
         ZMsg.ZLog.MsgTrigger  = (tSHORT) MsgTrigger;
         ZMsg.ZLog.MsgInterval = (tSHORT) MsgInterval;
         ZMsg.ZLog.MsgOffset   = (tSHORT) MsgOffset;
         BldZLog(&ZMsgBuf, &ZMsg.ZLog);
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.ZLog) + HDR_LEN);
    
         CntZLog++;
         send_msg(tx_buff);
      }
      break;   
   
   case sF10: 
      // Ephemeris request
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      if(DataType == NC_BINARY){
        alm_age_req();
      }
      else if(DataType == Z_BINARY){
        eph_request();
      }  
      break;       
      
   case 135: //  sF11:  

      // req iono and utc data
      if(!msg_support(NC_BINARY + Z_BINARY)) break;

      if(DataType == NC_BINARY){
	      make_tx_header(213, 13);
	      *(unsigned short *)(tx_buff+10) = 113;
	      *(unsigned short *)(tx_buff+12) = 0x05;
	      *(unsigned long  *)(tx_buff+14) = (long)1;
	      clear_message_line();
	      _outtext("REQUESTING IONO AND UTC DATA");
                   
	      cnt201++;             
	      send_msg(tx_buff);
      }                

      if(get_ephemeris_file()){
         cputs("\a\a"); 
         wait(1.f);
      }
      else{
          send_ephemeris();
      }

      break;

   case 136: //  sF12:
      // almanac upload 
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      if(get_almanac_file()){
         cputs("\a\a"); 
         wait(1.f);
      }
      else{
          if(DataType == NC_BINARY){
            clear_message_line();      
            alm_rate = ask_short("ALMANAC UPLOAD RATE (1-4 HZ) -> ", 1, &valid);
            clear_message_line();   
            if(!valid) break;   
            alm_delay = timer();
          }                
          send_almanac();
      }
      if(get_utc_file()){
         cputs("\a\a"); 
         wait(1.f);
      }
      else{
          send_utc();
      }

      break; 
   
   case 1:              /* Escape char */
      break;
   case 16:             // Q or q  
   
      // only quit program if not replaying data
      if(playback){
         // quit playback and close playback file and reopen gps port
         if(plyfileopen){
            clear_message_line();  
            sprintf(buff,"CLOSING GPS PLAYBACK FILE %s",gpsplyfile); 
            _outtext(buff); cputs("\a\a");       
            fclose(stream); 
            plyfileopen = 0;
            wait(1.f);
         } 
//         if(extfileopen){
//            if(xtract && strcmp(xtractid,"SVD") == 0){
//               svout();   //call output routine in xsvd.c to write data
//            }
//            clear_message_line();  
//            sprintf(buff,"CLOSING XTRACT DESTINATION FILE %s",gpsextfile); 
//            _outtext(buff); cputs("\a\a"); 
//            if(!fxtract)
//               fprintf(stream3, "\nPERCENT NAV: %7.3f\t NAV: %ld\t TOTAL: %ld\t",
//                      (float) (CntNav * 100/CntPnt), CntNav, CntPnt);      
//            fclose(stream3);
//            extfileopen = 0;
//            fxtract = 0;
//            wait(1.f);
//         } 
         playback = 0;   
//         open_gps = 1;
//         xtract   = 0;
//         fxtract  = 0;
      }
//      else{  
         // quit the program 
//         want_exit = 1;    /* keyboard exit */  
//      }

         if(extfileopen){
            if(xtract && strcmp(xtractid,"SVD") == 0){
               svout();   //call output routine in xsvd.c to write data
            }
            clear_message_line();  
            sprintf(buff,"CLOSING XTRACT DESTINATION FILE %s",gpsextfile); 
            _outtext(buff); cputs("\a\a"); 
            if(!fxtract)
               fprintf(stream3, "\nPERCENT NAV: %7.3f\t NAV: %ld\t TOTAL: %ld\t",
                      (float) (CntNav * 100/CntPnt), CntNav, CntPnt);      
            fclose(stream3);
            extfileopen = 0;
            fxtract = 0;
            wait(1.f);
         } 
         open_gps = 1;
         xtract   = 0;
         fxtract  = 0;
         want_exit = 1;    /* keyboard exit */  

      break;

   case cF1:      
      // navigation solution validity 
      
      // get input parameters    
      if(DataType == Z_BINARY){
         clear_message_line();   
         AltNotUsedReq = ask_short("ALTITUDE USE NOT ALLOWED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
         DGPSRequired = ask_short("DGPS REQUIRED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
         MinimumSats = ask_short("MINIMUM SATS USED (0-12) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
         MaxEHPE = ask_float("MAX EXPECTED HORIZ POS ERROR (0-1000 M) -> ", 100, &valid);
         clear_message_line();   
         if(!valid) break;
         MaxEVPE = ask_float("MAX EXPECTED VERT POS ERROR (0-1000 M) -> ", 150, &valid);
         clear_message_line();   
         if(!valid) break;
         DRMeasRequired = ask_short("DR MEASUREMENTS REQUIRED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
         ConGPSRequired = ask_short("CONCURRENT GPS/DR REQUIRED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
         GPSOnlyRequired = ask_short("GPS ONLY REQUIRED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
      }
      else if((DataType == NC_BINARY) || (DataType == NC_NMEA)){
         clear_message_line();   
         Auto_2D = 
          ask_short("ENABLE 3 SV NAV FROM ACQUISTION (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;
      }
      
      // build message
      if(DataType == Z_BINARY){
         memset(&ZMsg.Msg1217, 0, sizeof(ZMsg.Msg1217));
         SolValidData.AltNotUsedReq   = (tBOOL) AltNotUsedReq;
         SolValidData.DGPSRequired    = (tBOOL) DGPSRequired;
         SolValidData.DRMeasRequired  = (tBOOL) DRMeasRequired;
         SolValidData.ConGPSRequired  = (tBOOL) ConGPSRequired;
         SolValidData.GPSOnlyRequired = (tBOOL) GPSOnlyRequired;
         ZMsg.Msg1217.MinimumSats = (tUSHORT) MinimumSats;
         ZMsg.Msg1217.MaxEHPE = (tULONG) (MaxEHPE * 1E+02);
         ZMsg.Msg1217.MaxEVPE = (tULONG) (MaxEVPE * 1E+02);
         BldZMsg(&ZMsgBuf, ZMsg, 1217);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1217) + HDR_LEN); 
         Cnt1217++;
         send_msg(tx_buff);  
      }
      else if((DataType == NC_BINARY) || (DataType == NC_NMEA)){
         init_2D();
      }
      break;

   case cF2:    
      // platform type 
      if(!msg_support(Z_BINARY)) break;
      clear_message_line();   
//      Platform = ask_short("PLATFORM TYPE (0=DEFAULT, 1=STATIC, 2=PED, "
//                          "3=LAKE, 4=SEA, 5=AUTO, 6=AIR) -> ", 0, &valid);
      Platform = ask_short("PLATFORM DYNAMICS TYPE (0=DEFAULT, 2=LOW, "
                           "5=MED, 6=HIGH) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;   

      // Enforce limitations on platform type until others are tested.
      if (Platform != 0 && Platform != 2 && Platform != 5 && Platform != 6){
         valid = 0;
         break;
      }

      memset(&ZMsg.Msg1220, 0, sizeof(ZMsg.Msg1220));
      ZMsg.Msg1220.Platform = (tSHORT) Platform;
      BldZMsg(&ZMsgBuf, ZMsg, 1220);  
      memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1220) + HDR_LEN); 
      Cnt1220++;
      send_msg(tx_buff);       
      break;

   case cF3: 
      // nav configuration
      if(!msg_support(NC_BINARY+Z_BINARY)) break;
      clear_message_line();

      if (DataType == NC_BINARY)  // NavCore binary
      {
         StaticNavEnable = ask_short("STATIC NAV ENABLED (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;
         static_nav();
         cnt201++;
         send_msg(tx_buff);
      }
      else  // Zodiac binary
      {
         DisableHeldAltitude =
            ask_short("DISABLE HELD ALTITUDE (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         DisableGTSmoothing =
            ask_short("DISABLE GROUND TRACK SMOOTHING (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         DisablePosPinning =
            ask_short("DISABLE POSITION PINNING (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         DisableLowQualityMeas = ask_short("MAXIMIZE MEASUREMENT QUALITY/QUANTITY "
                              "(0=QUANTITY, 1=QUALITY) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         EnableJammingDetect =
            ask_short("ENABLE JAMMING DETECTION (0=NO, 1=YES) -> ", 0, &valid);
         clear_message_line();
         if(!valid) break;

         CN0Threshold =
            ask_short("CN0 THRESHOLD  (0..50) -> ", 1, &valid);
         clear_message_line();
         if(!valid) break;

         memset(&ZMsg.Msg1221, 0, sizeof(ZMsg.Msg1221));

         NavCfgBits.DisableHeldAltitude =
            (DisableHeldAltitude == 1) ? TRUE : FALSE;

         NavCfgBits.DisableGTSmoothing =
            (DisableGTSmoothing == 1) ? TRUE : FALSE;

         NavCfgBits.DisablePosPinning =
            (DisablePosPinning == 1) ? TRUE : FALSE;

         NavCfgBits.DisableLowQualityMeas =
            (DisableLowQualityMeas == 1) ? TRUE : FALSE;

         NavCfgBits.EnableJammingDetect =
            (EnableJammingDetect == 1) ? TRUE : FALSE;

         // put CN0Threshold into message buffer - if value is above upper limit then set to
         // upper limit
         CN0Threshold = (CN0Threshold < 50) ? CN0Threshold : 50;
         ZMsg.Msg1221.CN0Threshold = CN0Threshold;
         
         BldZMsg(&ZMsgBuf, ZMsg, 1221);
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1221) + HDR_LEN);
         Cnt1221++;
         send_msg(tx_buff);
      }
      break;

   case cF4: 
      // reserved
      break;

   case cF5:
      // cold start control
      if(!msg_support(NC_BINARY + Z_BINARY)) break;                 
      clear_message_line();   
      ColdStartDisable = ask_short("COLD START DISABLED (0=NO, 1=YES) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;
      if(DataType == Z_BINARY){
         ColdStartTimeOut= ask_short("COLD START TIMEOUT (SEC) -> ", 120, &valid);
         clear_message_line();   
         if(!valid) break;
      }
      // build message
      cold_start();
      break;

   case cF6: 
      // datum select
      clear_message_line();
      
      // control parameters for navcore or nmea protocol only
      if((DataType == NC_BINARY) || (DataType == NC_NMEA)){
         datum = ask_short("DATUM NUMBER (0-97) -> ", datum, &valid);
         clear_message_line();   
         if(!valid) break; 
         Molodensky(datum); 
                         
         // save the config file
         save_cfg();  
         break;
      }
      // control parameters for zodiac binary protocol only
      else if(DataType == Z_BINARY){
         datum = ask_short("DATUM NUMBER (0-188, 300-304) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;   

         memset(&ZMsg.Msg1211, 0, sizeof(ZMsg.Msg1211));
         ZMsg.Msg1211.DatumID = (tUSHORT) datum;
         BldZMsg(&ZMsgBuf, ZMsg, 1211);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1211) + HDR_LEN); 
         Cnt1211++;
         send_msg(tx_buff);       
      }
      break;

//   case cF7:   //   cF7 Reserved
//      i=0;
//      break;         

   case cF7:
      // antenna type  
      //if(!msg_support(0)) break;   // temp until added in future release
      if(!msg_support(Z_BINARY)) break;
      clear_message_line();   
      AntennaType = ask_short("ANTENNA TYPE"
                                    " (1=ACTIVE/SPEED, 0=PASSIVE/SENSITIVITY) -> ", 0, &valid);
      clear_message_line();   
      if(!valid) break;   
      
      memset(&ZMsg.Msg1218, 0, sizeof(ZMsg.Msg1218));
      AntennaData.Type = (tUSHORT) AntennaType;
      BldZMsg(&ZMsgBuf, ZMsg, 1218);  
      memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1218) + HDR_LEN); 
      Cnt1218++;
      send_msg(tx_buff);       
      break;

   case cF8:
      // mask angle 
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      elev_mask(); 
//      sprintf(buff,"%4.1f" , mask_angle); ShowText(buff,DOPR  ,DOPC+ 7); 
      sprintf(buff,"    "); ShowText(buff,DOPR  ,DOPC+ 7); 
      break;

   case cF9:
      // satellite selection
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      clear_message_line();  
      DisabledSat = 
         ask_short("SV TO TOGGLE (1-32, 0 ENABLES ALL) -> ", 0, &valid);
      clear_message_line();  
      if(!valid) break;     
      if(DataType == Z_BINARY){
          StorageSelect = 
             ask_short("STORE LIST IN EEPROM (0=NO, 1=YES) -> ", 0, &valid);
      }      
      clear_message_line();  
      if(!valid) break;      
      
      // Enable All if 0 entered
      if(DisabledSat == 0){
         SVs01To16 = 0xFFFF;         
         SVs17To32 = 0xFFFF;
      }
      else if(DisabledSat < 17){
         SVs01To16 ^=  1 << (DisabledSat - 1);
      }
      else{
         SVs17To32 ^=  1 << (DisabledSat -17);
      }
      
      // build message
      if(DataType == Z_BINARY){
         memset(&ZMsg.Msg1213, 0, sizeof(ZMsg.Msg1213));
         ZMsg.Msg1213.SelectedCandidates  =  (tULONG) SVs01To16;        // LSW
         ZMsg.Msg1213.SelectedCandidates |= ((tULONG) SVs17To32) << 16; // MSW
         ZMsg.Msg1213.StorageSelect = (StorageSelect != 0) ? 1 : 0;
         BldZMsg(&ZMsgBuf, ZMsg, 1213);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1213) + HDR_LEN); 
         Cnt1213++;
         send_msg(tx_buff);
      }
      else if(DataType == NC_BINARY){
         make_tx_header(208, 9);
         make_short(0x03, tx_buff, 6);
         tx_buff[11] = (BYTE)(mask_num & 0x000f);
         make_short(SVs01To16, tx_buff, 7);
         make_short(SVs17To32, tx_buff, 8);
         cnt208++;
         send_msg(tx_buff);
      
         // update display
         _settextposition(VISR+12,VISC+4);
         _outtext("            ");
      
         buff[0] = '\0';
         for(i=0;i<16;i++){
            if(((SVs01To16 >> i)&1)==0){
                sprintf(dissv, "%2d ", i+1);
                strcat(buff, dissv);
            }
         }
         for(i=0;i<16;i++){
            if(((SVs17To32 >> i)&1)==0){
                sprintf(dissv, "%2d ", i+17);
                strcat(buff, dissv);
            }
         }
         _settextposition(VISR+12,VISC+4);
         _outtext(buff);
      }
      break;

   case cF10:  
      // dgps control
      clear_message_line(); 
      
      // get control parameters
      DGPSDisable = ask_short("3D DGPS DISABLE (0=N, 1=Y) -> ", 0, &valid);
      clear_message_line(); 
      if(!valid) break;
      DGPSReset   = ask_short("3D DGPS DATABASE RESET (0=N, 1=Y) -> ", 1, &valid);
      clear_message_line(); 
      if(!valid) break;
      DGPSTimeOut = ask_short("3D DGPS CORRECTIONS TIMEOUT (SEC) -> ", 90, &valid);
      clear_message_line();  
      if(!valid) break;
      
      // control parameters for navcore or nmea protocol only
      if((DataType == NC_BINARY) || (DataType == NC_NMEA)){
         DGPS2DDisable = ask_short("2D DGPS DISABLE (0=N, 1=Y) -> ", 0, &valid);
         clear_message_line(); 
         if(!valid) break;
         DGPS2DTimeOut = 
           ask_short("2D DPGS CORRECTIONS TIMEOUT (SEC, 0=NONE) -> ", 45, &valid);
         clear_message_line(); 
         if(!valid) break;
         RTCMType5Enable = 
           ask_short("RTCM TYPE 5 MSG ENABLE (NONE=0, 2.0=1, 2.1=2) -> ", 1, &valid); 
         clear_message_line();  
         if(!valid) break; 
      }
         
      // control parameters for navcore binary protocol only
      if(DataType == NC_BINARY){
         clear_message_line();
         Rate = ask_short("DGPS STATUS INTERVAL (SEC) -> ", 1, &valid);
         clear_message_line(); 
         if(!valid) break; 
         RTCMPacketLen = ask_short("MSG 210 LENGTH (0-32 WORDS) -> ", 20, &valid);
         clear_message_line();
         if(!valid) break;
         if(!RTCMPacketLen) RTCMPacketLen = 2;       
      }
      // control parameters for zodiac binary protocol only
      else if (DataType == Z_BINARY){
         RTCMPacketLen = ask_short("MSG 1351 LENGTH (0-32 WORDS) -> ", 20, &valid);
         clear_message_line();
         if(!valid) break;
         if(!RTCMPacketLen) RTCMPacketLen = 2;
      }
         
      // build messages
      if(DataType == Z_BINARY){
         memset(&ZMsg.Msg1214, 0, sizeof(ZMsg.Msg1214));            
         DGPSControlData.DGPSDisable = (tBOOL)  DGPSDisable;
         DGPSControlData.DGPSReset   = (tBOOL)  DGPSReset;
         ZMsg.Msg1214.TimeOut                     = (tUSHORT) DGPSTimeOut;
         BldZMsg(&ZMsgBuf, ZMsg, 1214);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1214) + HDR_LEN); 
         Cnt1214++;
         send_msg(tx_buff);       
     }
      else if(DataType == NC_BINARY){
         // navcore binary 
         make_tx_header(209, 14);
         *(unsigned short *)(tx_buff+10) = 0x0001;
         *(unsigned short *)(tx_buff+12) = !DGPSDisable;
         *(unsigned short *)(tx_buff+14) = DGPSReset;
         *(unsigned short *)(tx_buff+16) = DGPSTimeOut;
         *(unsigned short *)(tx_buff+18) = Rate;
         *(unsigned short *)(tx_buff+22) = DGPS2DDisable + DGPS2DTimeOut << 4;
         *(unsigned short *)(tx_buff+24) = RTCMType5Enable;        
         cnt209++;        
         send_msg(tx_buff);
      }
      else if(DataType  == NC_NMEA){
         if(DGPSReset)     d_rst  = 'A';
         else              d_rst  = 'V'; 
                                
         if(DGPSDisable)   d_ctl  = 'V';
         else              d_ctl  = 'A';
                
         if(DGPS2DDisable) d_ctl2 = 'V';
         else              d_ctl2 = 'A';
        
         sprintf(nmea_msg, "$PRWIIDGP,%c,%c,%i,%c,%i,%i", 
                     d_ctl, d_rst, DGPSTimeOut,d_ctl2, 
                     DGPS2DTimeOut, RTCMType5Enable);
         cntidgp++; 
         send_nmea_msg(nmea_msg);
         wait(1.5f);
      }    
      break;
      
   case 137:   //  cF11 
      // power management control
      
      if(!msg_support(NC_BINARY + Z_BINARY)) break;
      
      // control parameters for zodiac binary protocol only
      //
      if(DataType == Z_BINARY){
         clear_message_line();   
         dutycycle = ask_short("POWER MANAGEMENT DUTY CYCLE (0-4 secs off, 0=disable) -> ", 0, &valid);
         clear_message_line();   
         if(!valid) break;   

         memset(&ZMsg.Msg1317, 0, sizeof(ZMsg.Msg1317));
         ZMsg.Msg1317.DutyCycle = (tUSHORT) dutycycle;
         BldZMsg(&ZMsgBuf, ZMsg, 1317);  
         memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1317) + HDR_LEN); 
         Cnt1317++;
         send_msg(tx_buff);
         break;       
      }
      
      
      // control parameters for navcore binary protocol only
      //
      if(DataType == NC_BINARY){
         make_tx_header(211, 12);
         clear_message_line();
         *(unsigned short *)(tx_buff+10) = 3;
         *(unsigned short *)(tx_buff+12) = 
                      ask_short("NAV UPDATE RATE (SEC) -> ", 1, &valid);
         clear_message_line(); 
         if(!valid) break; 
         *(unsigned short *)(tx_buff+14) =
                      ask_short("ACQUISITION TIMEOUT (SEC) -> ", 90, &valid);
         clear_message_line();
         if(!valid) break; 
         *(unsigned short *)(tx_buff+16) = 
                      ask_short("LOW POWER TIMEOUT (SEC) -> ", 90, &valid);
         clear_message_line();  
         if(!valid) break;    
         cnt211++;
         send_msg(tx_buff);
         break; 
      }

    case 138:   //  cF12
      break;         
      
   case aF1:

      CloseGPS();

      // prompt for changes to PC ports
      clear_message_line();
      gpscom = ask_short("GPS COM PORT (0-4) -> ", gpscom, &valid);     
      clear_message_line();                   
      if(!valid) break;
//      gpsirq  = ask_short("IRQ (3,4,5,7) -> ", gpsirq, &valid); 
//      clear_message_line();
//      if(!valid) break;
      // default irq setting for selected com port
      switch(gpscom){
         case  1: gpsirq = 4; break;
         case  2: gpsirq = 3; break;
         case  3: gpsirq = 4; break;
         case  4: gpsirq = 3; break;
         default: break;
      }
      gpsbaud = ask_long("BAUD RATE (300-115200) -> ", gpsbaud, &valid);
      clear_message_line();
      if(!valid) break;      
      gpsprty = ask_char("PARITY (N,O,E) -> ", gpsprty, &valid);
      gpsprty = toupper(gpsprty);
      clear_message_line(); 
      if(!valid) break;
      gpsnbit = ask_short("NUMBER OF DATA BITS (7,8) -> ", gpsnbit, &valid); 
      clear_message_line();
      if(!valid) break;   
      gpssbit = ask_short("NUMBER OF STOP BITS (1,2) -> ", gpssbit, &valid);
      clear_message_line(); 
      if(!valid) break;
         
      // save the new ini file data
      save_ini();
      
//      CloseGPS();
      open_gps  = 1; 
      
      // prompt for changes to RTCM-104 port 
       tempchar[0] = ask_char("MODIFY RTCM COM PORT SETTINGS? (Y,N) -> ",'N',&valid);
      clear_message_line();  
      if(!valid) break;           
      if(toupper(tempchar[0]) == 'N') break;

      CloseDGPS();
 
      clear_message_line();  
      difcom = ask_short("RTCM COM PORT (0-4) -> ", difcom, &valid);     
      clear_message_line(); 
      if(!valid) break; 
//      difirq  = ask_short("IRQ (3,4,5,7) -> ", difirq, &valid); 
//      clear_message_line(); 
//      if(!valid) break;
      // default irq setting for selected com port
      switch(difcom){
         case  1: difirq = 4; break;
         case  2: difirq = 3; break;
         case  3: difirq = 4; break;
         case  4: difirq = 3; break;
         default: break;
      }
      difbaud = ask_short("BAUD RATE (3/6/12/24/48/9600) -> ", difbaud, &valid);
      clear_message_line();
      if(!valid) break;  
      difprty = ask_char("PARITY (N,O,E) -> ", difprty, &valid);
      difprty = toupper(difprty); 
      clear_message_line();
      if(!valid) break;  
      difnbit = ask_short("NUMBER OF DATA BITS (7,8) -> ", difnbit, &valid); 
      clear_message_line(); 
      if(!valid) break;  
      difsbit = ask_short("NUMBER OF STOP BITS (1,2) -> ", difsbit, &valid); 
      clear_message_line(); 
      if(!valid) break;
                                                       
      // save the new ini file data  
      save_ini();
      
//      CloseDGPS();
      open_dgps = 1;     
      break;  
      
   case aF2:   
      // set labmon message protocol
      DataType *= 2; 
      if(DataType > Z_NMEA) DataType = NC_BINARY;
      clear_screen();  
      clear_message_line();
      switch (DataType) {
         case NC_BINARY:
            _outtext("LABMON MESSAGE PROTOCOL SET TO NAVCORE BINARY");
            break;
         case NC_NMEA:
            _outtext("LABMON MESSAGE PROTOCOL SET TO NAVCORE NMEA-0183");
            break;
         case Z_BINARY:
            _outtext("LABMON MESSAGE PROTOCOL SET TO ZODIAC BINARY");
            break;
         case Z_NMEA:
            _outtext("LABMON MESSAGE PROTOCOL SET TO ZODIAC NMEA-0183");
            break;
      }
      wait(.5f);  
     
      // save the config file
      save_cfg();  
      break;
      
   case aF3:     
      // process the config file
      proc_cfg();

      // set the reference position
      clear_message_line(); 
      tempchar[0] = ask_char("USE CURRENT POSITION (Y,N) -> ", 'N', &valid);
      clear_message_line();  
      if(!valid) return;     
      if(toupper(tempchar[0]) != 'Y'){
         ref_lat = ask_dbl("REFERENCE LATITUDE (+N/-S DEG) -> ", ref_lat, &valid);
         clear_message_line();  
         if(!valid) return;
         ref_lon = ask_dbl("REFERENCE LONGITUDE (+E/-W DEG) -> ", ref_lon, &valid);
         clear_message_line();      
         if(!valid) return;
         ref_alt = ask_dbl("REFERENCE ALTITUDE (M) -> ", ref_alt, &valid);
         clear_message_line();     
         if(!valid) return; 
      }
      else{
         if((DataType == NC_BINARY) || (DataType == Z_BINARY)){
            ref_lat = lat * R2D;
            ref_lon = lon * R2D;
         }
         ref_alt = alt;
      }
      // save the config file
      save_cfg();
      break;
     
   case aF4:
      MainBackColor++;
      if(MainBackColor > 15){
         MainBackColor = 0;
      }                 
      _setbkcolor(MainBackColor);         
      _clearscreen(_GCLEARSCREEN);
      menu_on = 1;
      current_menu = 4;
      display_menus(&current_menu);  
      show_screen_titles();
      show_visible_sats();
      
      // save the config file
      save_cfg();  
      break;  

   case aF5:
      MainTextColor++;
      if(MainTextColor > 15){
         MainTextColor = 0;
      }         
      
      _clearscreen(_GCLEARSCREEN); 
      menu_on = 1;
      current_menu = 4;
      display_menus(&current_menu);  
      show_screen_titles();
      show_visible_sats();  
      
      // save the config file
      save_cfg();  
      break;  

   case aF6:
      MainDataColor++;
      if(MainDataColor > 15){
         MainDataColor = 0;
      }
     
      _clearscreen(_GCLEARSCREEN); 
      menu_on = 1;
      current_menu = 4;
      display_menus(&current_menu);
      show_screen_titles();
      show_visible_sats();    
      
      // save the config file
      save_cfg();  
      break;  

   case aF7:
      MenuBackColor++;
      if(MenuBackColor > 15){
         MenuBackColor = 0;
      } 
      _setbkcolor(MainBackColor);
      _clearscreen(_GCLEARSCREEN);
      menu_on = 1;
      current_menu = 4;
      display_menus(&current_menu);  
      show_screen_titles();
      show_visible_sats();     
      
      // save the config file
      save_cfg();  
      break;  
 
   case aF8:
      MenuKeysColor++;
      if(MenuKeysColor > 15){
         MenuKeysColor = 0;
      }
     
      _clearscreen(_GCLEARSCREEN);  
      menu_on = 1;
      current_menu = 4;
      display_menus(&current_menu);  
      show_screen_titles();
      show_visible_sats();
      
      // save the config file
      save_cfg();      
      break;  

   case aF9:
      MenuDescColor++;
      if(MenuDescColor > 15){
         MenuDescColor = 0;
      }
     
      _clearscreen(_GCLEARSCREEN); 
      menu_on = 1;      
      current_menu = 4;
      display_menus(&current_menu);  
      show_screen_titles();
      show_visible_sats();  
             
      // save the config file
      save_cfg();  
      break;  

   case aF10:
      clear_message_line();  
      MagnaMode = 
      ask_short("ENTER MAGNA MODE (0=OFF, 1=FAST ACQ, 2=ON) -> ", MagnaMode, &valid);     
      clear_message_line(); 
      if(!valid) break; 

      CNoLevel =
      ask_short("ENTER CN0 LIMIT (0=34DB,1=32DB,2=30DB...6=22DB,7=20DB) -> ", CNoLevel, &valid);     
      clear_message_line(); 
      if(!valid) break; 

	  ZMsg.Msg1292.SequenceNumber = 0;
	  ZMsg.Msg1292.MagnaMode = MagnaMode;
	  ZMsg.Msg1292.EnableLowCNo = CNoLevel;
	  for(i=0; i<8; i++)
	  	ZMsg.Msg1292.dummyin[i] = 0;
	  ZMsg.Msg1292.OKToPowerDown = 0;
	  ZMsg.Msg1292.ContinuousTracking = 0;
	  ZMsg.Msg1292.RTCInterval = 0;
	  for(i=0; i<6; i++)
	  	ZMsg.Msg1292.dummyout[i] = 0;
	   
	  BldZMsg(&ZMsgBuf, ZMsg, 1292);
	  memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1292) + HDR_LEN); 
	  Cnt1292++;       
	  send_msg(tx_buff);      
      break;
     
   case 139:     // aF11
      clear_message_line();
//      strcpy(MagnaMeasFileName,"MEASURE.MAG");
      ask_str("ENTER FILE NAME TO SAVE MAGNA MEASUREMENTS -> ", MagnaMeasFileName, &valid); 
      clear_message_line();
      if(!valid) break;
      if(MagnaMeasFilePtr != NULL) fclose(MagnaMeasFilePtr); 
      if((MagnaMeasFilePtr = _fsopen(MagnaMeasFileName, "rb", SH_DENYWR)) == NULL){
         sprintf(buff,"COULDN'T OPEN FILE %s!",MagnaMeasFileName); 
         _outtext(buff);
      }
      break; 

   case 140:   // aF12 
   	  clear_message_line();
      if((MagnaMeasFilePtr =_fsopen("MEASURE.MAG","wt",_SH_DENYRD)) == NULL) {
      	sprintf(buff,"COULDN'T OPEN FILE MEASURE.MAG");
      	_outtext(buff);
      	break;
      }     
      sprintf(buff,"STORE MAGNA MEASUREMENTS TO FILE MEASURE.MAG");
      _outtext(buff);
      break;
            
   default:
      clear_message_line();
      sprintf(buff,"UNIDENTIFIED COMMAND! %3d",kb.scan);  
      cputs("\a\a");
      _outtext(buff);
      break;
   }
}

//=====================================================================
                                             

void process_msg(void) /* Process Completed Message  */
{
   short i, sv, FOM, Ref_Week, GPSWeek, day, dow, month, year, sats_used;
   char    *dayname[7] ={"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"}; 
   char    CorrType[4];
   float drift, bias, hdop, vdop, pdop, tdop, gdop, ehpe, evpe;
   double   posx, posy, posz, utc_time, gps_time; 
   short      ionoval, utcval;
   double   a0, a1, tls, tot;
   double   alpha0, alpha1, alpha2, alpha3;
   double   beta0, beta1, beta2, beta3;
   long  st, tup, cs;
   short os, len, id_code, tmp;  
   short CorrEnabled, ValidTrack;
   
   id_code = get_I16(2);

   if(msgbuff[7] & 0x0C){
      message_acknowledgment(id_code);
      return;
   }
   if(BITTest && (id_code != 101)) return; 

   // show message counters and determine if any proprietary messages
   show_count();            
   if(!rockwell_link & (cnt153 || cnt2319 || cnt2309)){
      rockwell_link = 1;  
      show_screen_titles();
   }
   
   switch (id_code){  
   
   case 101:
        cnt101++;  
        show_BIT_test_results();  
        getch();   
        _clearscreen(_GCLEARSCREEN);    
        menu_on = 1;  
        current_menu = 1;   
        display_menus(&current_menu);   
        show_screen_titles();  
        show_visible_sats();    
        BITTest = FALSE;    
        break;  

   case 102:   
      cnt102++;
      get_visible_sats();
      show_visible_sats(); 
      
      st = get_I32(6);               /* Set Time */ 
      sprintf(buff, "%8lu ",st);                // set time
      _settextposition(TIMR+5,TIMC+9);
      _outtext(buff);           
      break;

   case 153:
   case 103:

      /* Time Mark Block or Extended Time Mark Block */

      if(id_code == 103){ 
         cnt103++;
         os = 0;
      }             /* Set offset into message */
      else{     
         cnt153++;
         os = 2;       /* based on 153 or 103     */
      }

      st = get_I32(17 + os);               /* Set Time */
      posx =  get_F40(19 + os);            /* pos-84 X */
      posy =  get_F40(22 + os);            /* pos-84 Y */
      posz =  get_F40(25 + os);            /* pos-84 Z */

      FOM   = get_I16(63+ os) >> 8 & 0x0F;

      day   = get_I16(14 + os);
      month = get_I16(15 + os);
      year  = get_I16(16 + os);
      hdop  = (float) (get_I16(42 + os)/100.0);     
      vdop  = (float) (get_I16(43 + os)/100.0);     
      pdop  = (float) (get_I16(44 + os)/100.0);     
      tdop  = (float) (get_I16(45 + os)/100.0);  
      gdop  = (float) (get_I16(46 + os)/100.0);
      ehpe  = (float) (get_I16(57 + os));  
      evpe  = (float) (get_I16(58 + os));
      utc_time = get_F40(11 + os);
      gps_time = get_F40(6 + os);
      GPSWeek = get_I16(9 + os);

      sats_used = (get_I16(63 + os) >> 4) & 0x07;
     
      show_navcore_status(os);  

      sprintf(buff,"%4d", sats_used);            // sats used
      _settextposition(DOPR-2,DOPC+7);
      _outtext(buff);                     
      
      /* get oscillator ppm from word 61 bits 0-7, bit 8 is sign */
      /* and is a two's complement value                         */
      tmp = (get_I16(61+os) & 0xFF);
      if((get_I16(61+os) & 0x100) != 0){
         tmp = tmp | 0xFF00;
      }
      osc_ppm = (float) tmp / 10.f;
      sprintf(buff, "%9.2G", osc_ppm);
      _settextposition(CBER+2,CBEC+3);
      _outtext(buff);

      if(os){
         drift = get_F24(68);                        
         sprintf(buff, "%9.2G", drift);
         _settextposition(CBER+2,CBEC+3);
         _outtext(buff);

         bias = get_F24(66);                         
         sprintf(buff, "%9.2G", bias);
         _settextposition(CBER,CBEC+3);
         _outtext(buff);
      }

      sprintf(buff, "%5d", FOM);                 // FOM
      _settextposition(MODR+1,MODC+5);
      _outtext(buff);

      sprintf(buff, "%6.2f", gdop);              // GDOP
      _settextposition(DOPR+1,DOPC+5);
      _outtext(buff);
     
       sprintf(buff, "%6.2f", pdop);             // PDOP
      _settextposition(DOPR+2,DOPC+5);
      _outtext(buff);

      sprintf(buff, "%6.2f", hdop);              // HDOP
      _settextposition(DOPR+3,DOPC+5);
      _outtext(buff);

      sprintf(buff, "%6.2f", vdop);              // VDOP
      _settextposition(DOPR+4,DOPC+5);
      _outtext(buff);

      sprintf(buff, "%6.2f", tdop);              // TDOP
      _settextposition(DOPR+5,DOPC+5);
      _outtext(buff);
  
      sprintf(buff,"%02d/%02d/%02d ", month, day, (year%100));// UTC date
      _settextposition(TIMR,TIMC+9);
      _outtext(buff);

      _settextposition(TIMR+1,TIMC+4);           // UTC
      show_time(utc_time);
      _settextposition(TIMR+1,TIMC+4);
      if(get_I16(10 + os)) _outtext("*");        // shows UTC &valid
      else _outtext(" ");
 
      sprintf(buff,"%4d ",GPSWeek);             // GPS week
      _settextposition(TIMR+4,TIMC+5); 
      _outtext(buff);
                           
      dow = (short)(gps_time / 86400.0);           // day of week
      sprintf(buff,"%s", dayname[dow]);       
      _settextposition(TIMR+4,TIMC+14);
      _outtext(buff);        
      
      sprintf(buff, "%8lu ",st);                // set time
      _settextposition(TIMR+5,TIMC+9);
      _outtext(buff);
                      
      lat = get_F40(34+os);      /* Latitude */
      lon = get_F40(37+os);      /* Longitude */
      alt = get_F24(40+os);      /* Altitude */
                  
      show_lla();                              // lat, lon and alt 
      
      sprintf(buff, "  %10.1f", posx);           // WGS-84 position
      _settextposition(POSR  ,POSC+4); _outtext(buff);      
      sprintf(buff, "  %10.1f", posy);          
      _settextposition(POSR+1,POSC+4); _outtext(buff);
      sprintf(buff, "  %10.1f", posz);           
      _settextposition(POSR+2,POSC+4); _outtext(buff);
     
      show_Velocity(os);                         // velocity    
      
      show_channels(os);                         // channels   
         
      // power management status 
      _settextposition(PMSR,PMSC+5);
      if(get_I16(62+os) & 0X0001){
         _outtext(" FULL");  
      }
      else{
         _outtext("  CYC"); 
      } 

   // get delta positions when in delta or xtract modes
   if (delta || xtract){
      // load tGeoPos structs with terms in degrees
      GeoPos.lat = lat * R2D; 
      GeoPos.lon = lon * R2D;
      GeoPos.alt = alt;
      RefGeoPos.lat = ref_lat;
      RefGeoPos.lon = ref_lon;
      RefGeoPos.alt = ref_alt;
      
      GeoidToENU( GeoPos, RefGeoPos, ENU );  // call function to calculate delta's
   
      ENU[2] -= ref_alt;  // this converts the change in altitude because ENU[2] is maintained stationary
   }
   
   

      // output either whole value or delta from reference    
      if(!delta){   
         out_lon = lon * R2D;   
         out_lat = lat * R2D;   
         out_alt = alt;   
      }   
      else{   

         out_lat = ENU[0];    
         out_lon = ENU[1];    
         out_alt = ENU[2];      
      }    

      // filter the data using binary mode parameters      
      CntPnt++;  // jc added counter update for navcore binary 8-18-96

      if((FOM       <= minfom) &&      
         (sats_used >= minsats) &&        
         (pdop      <= maxpdop) &&       
         (hdop      <= maxhdop) &&       
         (vdop      <= maxvdop)  ){       
               
         filter_on = 0; 
         CntNav++;  // jc added counter update for navcore binary 8-18-96
             
         // write extracted data to a file
         if(xtract && strcmp(xtractid,"LLA") == 0){     

            dlon = ENU[0];    
            dlat = ENU[1];    
            dalt = ENU[2];      
         
            if( ABS_LLA ) // wants to remove signs on lat log for plotting
               fprintf(stream3, "%10.3f \t%10.6f \t%11.6f \t%9.2f \t%10.2f \t%11.2f \t%9.2f\n",      
                  gps_time, fabs(lon * R2D), fabs(lat * R2D), alt, dlon, dlat, dalt);
            else          // wants to leave signs on lat log like displayed values
               fprintf(stream3, "%10.3f \t%10.6f \t%11.6f \t%9.2f \t%10.2f \t%11.2f \t%9.2f\n",      
                  gps_time, lon * R2D, lat * R2D, alt, dlon, dlat, dalt); 
                 
         }                
      }      
      else{      
         filter_on = 1;      
      }      
    
      // indicate when filtering is occurring 
      show_filter(filter_on);
 
      break;

   case 104:   
      cnt104++;   
      if(!get_I16(6)){
         // data is not available for this sat
         break;
      }
      sv = get_I16(13);
      Ref_Week = get_I16(16);
      BlocksRec++;                               /* INC block counter */

      clear_message_line();
      sprintf(buff, "ALMANAC FOR SV #%2d, %2d OF %2d,", sv, BlocksRec, SatsInAlm);
      _outtext(buff);
      sprintf(buff, "  REFERENCE WEEK -> %d", Ref_Week);
      _outtext(buff);

       
      *(unsigned short*)(msgbuff)= 0x81FF;         /* Restore header */
      *(short*)(msgbuff+2)= 205;                   /* Msg ID LSB */
      len = 74;                                  /* Byte Count */
      *(short*)(msgbuff+4) = len/2;                /* Word Count */
      *(short*)(msgbuff+6) = 0x1000;               /* Request Ack */

      cs = 0l;
      for(i=0;i<8;i+=2)
         cs += *(short*)(msgbuff+i);                  /* Compute Checksum */
      *(short*)(msgbuff+8) = (unsigned char) -cs;     /* Header Checksum ** aded cast */

      *(short*)(msgbuff+10)= 1;                    /* Init Block Control */
      *(short*)(msgbuff+12) = SatsInAlm;
      *(short*)(msgbuff+14)= BlocksRec;            /* Block Number */

      for (i=16;i<len+10; i+=2)                  /* Move 104 Data To 205 Format */
         *(short*)(msgbuff+i) = *(short*)(msgbuff+i+8);

      cs = 0l;
      for(i=10;i<84;i+=2) cs += *(short *)(msgbuff+i);
      cs = -cs;
      *(short*)(msgbuff+84) = (unsigned char) cs ;  /* Data Checksum **added cast */


      for (i=0; i < 86; i++, file_len++)
      filebuff[file_len] = msgbuff[i];        /* Save Data To File Buffer */

      if(BlocksRec == SatsInAlm){
      store_alm(file_len);
      SatsInAlm = BlocksRec = 0;              /* Reset Almanac Varibles */
      file_len = 0;
      clear_message_line();
      }  
      st = get_I32(7);               /* Set Time */ 
      sprintf(buff, "%8lu ",st);                // set time
      _settextposition(TIMR+5,TIMC+9);
      _outtext(buff);
      break;

   case 105:
      // age of almanac message contains info on entire almanac 
      cnt105++;                    
      SatsInAlm = get_I16(6);
      
      // request output of entire almanac
      alm_request();
      break;

   case 106: 
      cnt106++;                      /* Differential Status */
      show_diff_status();                                 
      break;

   case 107:
      cnt107++;
      // power cycling 
      _settextposition(PMSR,PMSC+5);
      if(get_I16(8) & 0X0001){
         _outtext(" FULL");  
      }
      else{
         _outtext("  CYC"); 
      }  
     
      // PM update rate
      _settextposition(PMSR+1,PMSC+5);  
      sprintf(buff, "    %1d", get_I16(10)); 
      _outtext(buff);    
      
      _settextposition(PMSR+2,PMSC+5);
      sprintf(buff, "   %2d", get_I16(11));
      _outtext(buff);    
        
      _settextposition(PMSR+3,PMSC+5);
      sprintf(buff, "   %2d", get_I16(12)); 
      _outtext(buff); 
    
            
      st = get_I32(7);               /* Set Time */ 
      sprintf(buff, "%8lu ",st);                // set time
      _settextposition(TIMR+5,TIMC+9);
      _outtext(buff);
      break;

   case 111:                  // Display pseudo ranges and rates.   
      cnt111++; 
        
      CorrEnabled = get_I16(6);     
      _settextposition(SETR,SETC+9); 
      if(CorrEnabled & 0x0700){
         // any range measurement corrections enabled
         _outtext("R");
      }
      else{
         _outtext(" ");
      }    

      strcpy(CorrType, "     ");
      if(CorrEnabled & 0x0100) CorrType[0] = 'C';
      if(CorrEnabled & 0x0200) CorrType[1] = 'T';
      if(CorrEnabled & 0x0400) CorrType[2] = 'D'; 
      sprintf(buff, "%03s", CorrType);
      _settextposition(SETR+6,SETC+7);
      _outtext(buff);
      
      for(i=0;i<5;i++){ 
         ValidTrack = get_I16(21+(i*7));       
         sprintf(buff, "%01d  %01d%01d%01d%01d%01d%01d%01d  %12.3lf %9.3lf",          
            (ValidTrack >> 9) & 0x0007, 
            (ValidTrack >> 6) & 0x0001, 
            (ValidTrack >> 5) & 0x0001, 
            (ValidTrack >> 4) & 0x0001,    
            (ValidTrack >> 3) & 0x0001, 
            (ValidTrack >> 2) & 0x0001, 
            (ValidTrack >> 1) & 0x0001,
            (ValidTrack     ) & 0x0001,    
            get_F40(22+(i*7)),get_F24(25+(i*7)));   
         _settextposition(PRMR+i,PRMC-12);   
         _outtext(buff);   
      }     
      st = get_I32(9);               /* Set Time */      
      sprintf(buff, "%8lu ",st);                // set time   
      _settextposition(TIMR+5,TIMC+9);   
      _outtext(buff);   
      break;   

   case 112:                  // Ephemeris message    
      cnt112++;    
      clear_message_line();   
      sprintf(buff, "EPHEMERIS FOR SV %d RECEIVED", get_I16(10));           
      _outtext(buff);      
         
      st = get_I32(6);               /* Set Time */    
      sprintf(buff, "%8lu ",st);                // set time   
      _settextposition(TIMR+5,TIMC+9);   
      _outtext(buff);   

      break;   

   case 113:                  // iono and utc message     
      cnt113++;   
      clear_message_line();   
      sprintf(buff, "IONO AND UTC DATA RECEIVED");   
      _outtext(buff);     
         
      // decode for debug     
      utcval = get_I16(6)      & 0x01;  // utc valid   
      ionoval= get_I16(6)>> 1  & 0x01;  // iono valid   
      st     = get_I32(7);              // set time     
      tup    = get_I32(9);              // update time   
      a0     = get_F24(11);             // A0            
      a1     = get_F24(13);             // A1   
      tls    = get_F24(14);             // tls   
      tot    = get_F24(17);             // tot   
      alpha0 = get_F24(24);             // alpha0   
      alpha1 = get_F24(26);             // alpha1   
      alpha2 = get_F24(28);             // alpha2   
      alpha3 = get_F24(30);             // alpha3   
      beta0  = get_F24(32);             // beta0       
      beta1  = get_F24(34);             // beta1       
      beta2  = get_F24(36);             // beta2        
      beta3  = get_F24(38);             // beta3    
         
      //clear_message_line();   
      //sprintf(buff, "  %lf %lf %lf %lf", alpha0, alpha1, alpha2, alpha3);            
      //_outtext(buff);         
      break;    
               
   case 117:    
      // aux port status   
      cnt117++;   
      if(get_I16(6)) auxstat = 'A';   // comm parameters &valid   
      else           auxstat = 'V';   
      auxbaud = get_I16(7);   
      switch(auxbaud){     
         case  0: auxbaud =  300; break;   
         case  1: auxbaud =  600; break;   
         case  2: auxbaud = 1200; break;   
         case  3: auxbaud = 2400; break;   
         case  4: auxbaud = 4800; break;    
         case  5: auxbaud = 9600; break;   
         default: auxstat = 'V' ; break; // invalid
      }   
      auxprty = (unsigned char) get_I16(8);   
      switch(auxprty){     
         case  0: auxprty = 'O'; break;   
         case  1: auxprty = 'E'; break;   
         case  2: auxprty = 'N'; break;   
         default: auxstat = 'V'; break; // invalid
      }   
      auxsbit = get_I16(9);     
      auxdbit = get_I16(10);    
      auxwcnt = get_I16(11);    
         
      // change background if parameters are invalid    
      sprintf(buff, "%04i%1c%1i%1i",auxbaud, auxprty, auxdbit, auxsbit);                       
      _settextposition(DSTR+2,DSTC-8);   
      if(auxstat != 'A'){    
         _setbkcolor(MenuBackColor);    
         _outtext(buff);   
      }      
      else{   
         _outtext(buff);    
      }    
      _setbkcolor(MainBackColor);   
      break;   
      
   case 152:   
      cnt152++;   
      break;   

   case 201:   
      cnt201++;   
      break;   

   case 202:   
      cnt202++;   
      break;   
         
   case 203:   
      cnt203++;   
      break;   

   case 204:   
      cnt204++;                              
      break;   
       
   case 205:   
      cnt205++;   
      break;   
          
   case 206:   
      cnt206++;   
      break;   
           
   case 207:   
      cnt207++;   
      break;   
           
   case 208:   
      cnt208++;   
      break;   
           
   case 209:   
      cnt209++;   
      break;   
           
   case 210:   
      cnt210++;   
                  
      // process dif-104 data   
      //eodata = 0;   
      //nrtcm = 0;      
      //while(!eodata){   
      //   procrtcm();   
      //}   
      break;   
           
   case 211:   
      cnt211++;   
      break;   
           
   case 213:   
      cnt213++;   
      break;   
         
   case 2309:   
      cnt2309++;   
      break;   

   case 2319:   
      cnt2319++;   
      break;   

   default:   
      clear_message_line();   
      sprintf(buff, "UNSUPPORTED NAVCORE BINARY MESSAGE ID %d", id_code);            
      _outtext(buff);   
      break;   
   }
   rec_cnt = 0;
   id_code = 0;
}

void send_msg(BYTE *msg)                      // Send message while ignoring receive buffer 
{
   short i, len, AckNack, MsgNum;
   long cs; 
   char MsgStr[5];

   for(i=0,cs=0L;i<8;i+=2) cs += *(short *)(msg+i);       // header checksum
   cs = -cs;
   *(short*)(msg+8) = (short)(cs & 0xFFFF);

   len = *(short*)(msg+4);             
   if(!len){
      len = 10;                         // Zero length mesages
   }
   else {
      len --; len *=2;
      for(i=0,cs=0L;i<=len;i+=2){
         cs += *(short*)(msg+i+10);   // body checksum 
      }
      
      if(vEEPTest)  // if vEEPTest is TRUE, the cs is forced to zero
      {             // causing the vEEP Block bad. The rx will report
      	 cs = 0;    // a bad block at the end of tranmission of all 16 
      }             // blocks.  Labmon resends all 16 again, up to 4
      else          // resends MAX.
      {
         cs = -cs;  
      }
      
      *(short*)(msg+len+12) = (short)(cs & 0xFFFF);

      len = *(short*)(msg+4);             
      len = (2*len)+12;                      // Compute number of bytes for for loop
   }

   for(i=0;i<len;i++){
      send_byte(msg[i]);
   } 
   
   if(TERMINAL) return;
     
   AckNack = *(short*)(msg+6); 
   MsgNum  = *(unsigned short*)(msg+2);
   if(MsgNum == 0xFFFF){
      sprintf(buff, "ALL DISC ");
   }
   else{
      sprintf(MsgStr, "%4d", MsgNum);
   
      if((AckNack & (D_BIT | L_BIT)) == (D_BIT | L_BIT)){ 
         // set up timing and disconnect
         sprintf(buff, "%4s LOGD", MsgStr);
      }   
      else if((AckNack & (C_BIT | L_BIT)) == (C_BIT | L_BIT)){ 
         // set up timing and connect 
         sprintf(buff, "%4s LOGC", MsgStr);
      }   
      else if(AckNack & D_BIT){ 
         // disconnect only
         sprintf(buff, "%4s DISC", MsgStr);
      }   
      else if(AckNack & C_BIT){ 
         // connect only
         sprintf(buff, "%4s CONN", MsgStr);
      }   
      else if(AckNack & Q_BIT){ 
         // quer only
         sprintf(buff, "%4s QERY", MsgStr);
      }   
      else if(AckNack & (L_BIT | E_BIT)){ 
         // log or extended log 
         sprintf(buff, "%4s LOG ", MsgStr);
      }
      else{ 
         // receiver input message
         sprintf(buff, "%4s SENT", MsgStr);
      }
   }
   _settextposition(MSGR,MSGC); _outtext(buff);
    
   // update the message counters if menu if off 
   if(!menu_on){
      show_count();
   }
}       

short read_byte(void)
{
    /*  get a byte from file then sent it out the serial port */
    
    short    i;

    kbhit();   

    i = fgetc(stream);

    if(i == EOF){
       // end playback
       clear_message_line();  
       sprintf(buff,"CLOSING GPS PLAYBACK FILE %s",gpsplyfile); 
       _outtext(buff); cputs("\a\a");       
       fclose(stream);
       plyfileopen = 0; 
       playback = 0;  
       CloseGPS(); 
       open_gps = 1;
       step = 0; 
       pause = 1;   
       
       rec_cnt   = 0;
       have_sync = 0;      
       cr_found  = 0;     
       ast_found = 0;     
       _fmemset(msgbuff, ' ', sizeof(msgbuff));       
       _fmemset(nmea_msg, ' ', 80); 
       wait(1.f);
       
       if(extfileopen){
          if(xtract && strcmp(xtractid,"SVD") == 0){
             svout();   //call output routine in xsvd.c to write data
          }
          clear_message_line();
          sprintf(buff,"CLOSING XTRACT DESTINATION FILE %s",gpsextfile); 
          _outtext(buff); //cputs("\a\a"); 
          if(!fxtract)
             fprintf(stream3, "\nPERCENT NAV: %7.3f\t NAV: %ld\t TOTAL: %ld\t",
                    (float) (CntNav * 100/CntPnt), CntNav, CntPnt);      
          fclose(stream3);
          extfileopen = 0;
          fxtract = 0;
          wait(1.f);
       }      
    }
    return (i);
}

short get_byte() // Get Byte If Available, Save To File
{
   short db;

   if(gps_tail == gps_head) return (-1);           // If No More Chars

   db = rx_buff[gps_tail];  
 // TESTING THIS IN INTERRUPT HANDLER
   if(save && !((DataType == NC_NMEA) && db == 0)){// old nmea sw has non-nmea nulls
      if(fputc(db,stream) == EOF){                 // Otherwise Get 'Em And Save 'Em
         fclose(stream);
         save = 0;
      }
   }

   gps_tail++;
   if(gps_tail >= MAX_RX_BUFFER){
      gps_tail = 0;   // Wrap Around If At The End
   }
   return(db);
}      

void FlushGPS()  // "clear" input buffer for gps data
{
   gps_tail = gps_head;
}

unsigned short get_byte_2() // Get a byte if available, save to file
{
   BYTE datar;
   
   if(dgps_open == 0) return (0xffff);             // Return -1 if not open
   if(dgps_tail == dgps_head) return (0xffff);             // Return -1 if no more chars

   else {
      datar = dgps_rx_buff[dgps_tail++];
      if(save2) fputc(datar, stream2);         // Otherwise get em and save em
      if(dgps_tail >= MAX_DGPS_RX_BUFFER){
         dgps_tail = 0; // Wrap around if at the end
      }
          
      return (datar);
    }
}

void FlushDGPS()  // "clear" input buffer for dgps data
{
   dgps_tail = dgps_head;
}


void __interrupt __far new_serial()             
{                                             
   short status;
      
   do{                                             // Get recieved data
      status = inp(gpsport+IIR);                   
      if(status & 0xF8){
         CloseGPS();
         break;                                    // port has disappeared
         }

      if((status & 6) == 4) rx_buff[gps_head++] = inp(gpsport);
      if((status & 6) == 6)inp(gpsport+LSR);    // Clear framing or gpsprty errors
      if((status & 6) == 0)inp(gpsport+MSR);

      if(gps_head >= MAX_RX_BUFFER) gps_head = 0;
      }while(status & 4);

// Testing saving data to file here instead of get_byte
//   if(save && !((DataType == NC_NMEA) && rx_buff[gps_head-1] == 0)){// old nmea sw has non-nmea nulls
//      if(fputc(rx_buff[gps_head-1],stream) == EOF){                 // Otherwise Get 'Em And Save 'Em
//         fclose(stream);
//         save = 0;
//      }
//   }
// end Test
  
   _disable();
   if (gpsirq > 7) outp(0xa0,EOI);  // end of interrupt for slave PIC
   outp(0x20,EOI);                  // end of interrupt for master PIC
   _enable();                    

}


void __interrupt __far new_dgps() 
{                                             
   short status = 0;

   do{
      status = inp(difport+IIR);
      if((status & 0xF8)) break;                   // port has disappeared
      if((status & 6) == 4) dgps_rx_buff[dgps_head++] = inp(difport);
      if((status & 6) == 6) inp(difport+LSR);    // Clear framing or gpsprty errors
      if((status & 6) == 0) inp(difport+MSR);
      if(dgps_head >= MAX_DGPS_RX_BUFFER) dgps_head = 0;
      }while(status & 4);

   _disable();
   if (gpsirq > 7) outp(0xa0,EOI);  // end of interrupt for slave PIC
   outp(0x20,EOI);                  // end of interrupt for master PIC
   _enable();                    

}

short IsPortAvail(short Port)
{
   short test;

   test = inp(Port+2); if(!(test&0xF8)) return 1;  // This is a serial port

   outp(Port,0xAA);
   test = inp(Port); if(test==0xAA) return 2;      // Else is a parallel port

   return 0;                                       // No Port here, Can use for PCMCIA

}

short IsIrqAvail(short IRQ)          // See if an interrupt is used 
{
   short tmp;
   if(IRQ < 8) tmp = inp(0x21);     // Get current IRQ's
   else{
     tmp = inp(0xA1);
     IRQ -= 8;
   }  
   return (tmp&(0x01 << IRQ)? 1:0);                            
}

void _gps_ReleaseIRQ(short IRQ)
{
   // Don't forget to retore _dos_setvect() after using this.

   short tmp;

   _disable();

   if(IRQ < 8){
     tmp = inp(0x21);     // Get current IRQ's
     tmp |=  0x01 << IRQ;
   }
   else{
     tmp = inp(0xA1);
     tmp |=  0x01 << (IRQ-8);
   }  
   if(IRQ < 8) outp(0x21,tmp);     // Get current IRQ's
   else{
     outp(0xA1,tmp);
   }

   _enable();

}
   void _out_ReleaseIRQ(short IRQ)
{
   // Don't forget to retore _dos_setvect() after using this.

   short tmp;

   _disable();

   if(IRQ < 8){
     tmp = inp(0x21);     // Get current IRQ's
     tmp |=  0x01 << IRQ;
   }
   else{
     tmp = inp(0xA1);
     tmp |=  0x01 << (IRQ-8);
   }  
   if(IRQ < 8) outp(0x21,tmp);     // Get current IRQ's
   else{
     outp(0xA1,tmp);
   }
   _enable();

}

void SetSystemIRQ(short IRQ)       // Enable interrupt in the 8259
{
   // CAUTION: 
   // Don't forget to use _dos_getvect() and _dos_setvect() before this.

   short tmp;

   _disable();

   if(IRQ < 8){
     tmp = inp(0x21);     // Get current IRQ's
     tmp &=  ~(0x01 << IRQ);
   }  
   else{
     tmp = inp(0xA1);
     tmp &=  ~(0x01 << (IRQ-8));
   }  
   if(IRQ < 8) outp(0x21,tmp);     // Get current IRQ's
   else{
     outp(0xA1,tmp);
   }
   _enable();
}

void SetGMT(void)
{
   struct tm *newtime;
   unsigned long ltime;
   
   time(&ltime);
   newtime = gmtime(&ltime);
            
   InitTime(newtime->tm_hour, newtime->tm_min,
      newtime->tm_mday, newtime->tm_mon+1, newtime->tm_year);

}


void InitTime(short hour, short min, short day, short month, short year)
{
   if(year < 1980) year += 1900;
   make_tx_header(201, 36);
   *(short*)(tx_buff+10) = 0x14;                      /* Time and Reset Bits */

   tx_buff[58] = (BYTE)hour;
   tx_buff[60] = (BYTE)min;
   tx_buff[64] = (BYTE)day;
   tx_buff[66] = (BYTE)month;

   *(short *)(tx_buff+68) = year;
   
}

void send_byte_2(BYTE db)
{
   short status = 0;

   if(IsPortAvail(difport)!=1) return;      // No port here

   do{
      status = (inp(difport+LSR)) & 0x60;
      if(status == 0x60) outp(difport,db);
      }while(status != 0x60);         

}



void send_byte(BYTE db)                      // Send data byte, This function is not interrupt driven
{
   short status = 0;

   if(IsPortAvail(gpsport)!=1) return;      // No port here
            
   if(save)
      fputc(db,stream);                      // Save Transmitted data
   do{
      status = (inp(gpsport+LSR)) & 0x60;       /* Strip Off Garbage On THR */
      if(status == 0x60)                       /* See If XMIT Hold Reg Is Empty */
      outp(gpsport,db);                         /* If So Then Send A Byte */
      } while(status != 0x60);                  /* Stay In Loop Until It's Sent */
}

//=====================================================================

short OpenGPS(short port, short IRQ, long rate, char gpsprty, short gpsnbit, short gpssbit)
{
   
   gps_head= gps_tail = 0;
   dgps_head= dgps_tail = 0;

   if(gps_open) CloseGPS();

   if(_gps_InitPort(port, IRQ, rate, gpsprty, gpsnbit, gpssbit)){ 
      // failure
      _settextcursor(0x0707);               /* Turn Cursor On. */
      _setvideomoderows(_TEXTC80,25);
      return 1;
   }
   else{ 
      // success
      gps_open = 1;
      
      gpsvector = vector(IRQ);

      old_serial = _dos_getvect(gpsvector);
      _dos_setvect(gpsvector, new_serial);

      outp(port+IER,0x01);  // Enable recieve interrupts
      SetSystemIRQ(IRQ);  
      return 0;
   }
}
//=====================================================================

short OpenOut(short port, short IRQ, long rate, char outprty, short outnbit, short outsbit)
{
   
   gps_head= gps_tail = 0;

   if(out_open) CloseOut();

   if(_out_InitPort(port, IRQ, rate, outprty, outnbit, outsbit)){ 
      // failure
      _settextcursor(0x0707);               /* Turn Cursor On. */
      _setvideomoderows(_TEXTC80,25);
      return 1;
   }
   else{ 
      // success
      out_open = 1;
      
      outvector = vector(IRQ);

      old_serial = _dos_getvect(outvector);
      _dos_setvect(outvector, new_serial);

      outp(port+IER,0x01);  // Enable recieve interrupts
      SetSystemIRQ(IRQ);  
      return 0;
   }
}

//=====================================================================

short OpenDGPS(short port, short IRQ, long rate, char difprty, short difnbit, short difsbit)
{
   
   if(dgps_open) CloseDGPS(); 
   
   if(_gps_InitPort(port, IRQ, rate, difprty, difnbit, difsbit)){
      // failure
      dgps_open = 0;
      return 1;
   }
   else{
      // success               
      old_dgps = _dos_getvect(IRQ+8);
      _dos_setvect(IRQ+8, new_dgps);

      difvector = vector(IRQ);
      
      old_dgps = _dos_getvect(difvector);
      _dos_setvect(difvector, new_dgps);

      outp(port+IER,0x01);     // Enable interrupts for receive only
      SetSystemIRQ(IRQ);
      dgps_open = 1;     
      return 0;
   }
}

//=====================================================================

short _gps_InitPort(short port, short IRQ, long rate, char gpsprty, short gpsnbit, short gpssbit)
{
   short tmp;

//   if(!IsIrqAvail(IRQ)) return 1;            // Check for used IRQ's
//   if(IsPortAvail(port)!=1) return 2;        // Look for avaiable serial ports

   outp(port + IER,0x00);                    // Disable comm port interrupts
   outp(port + LCR,0x80);                    // Set bit 7 on LCR to enable BRDL and BRDH

   outp(port, (BYTE)(115200/rate)&0xFF);           // BRDL , low baud divisor
   outp(port + IER,(BYTE)(115200/rate)>>8);        // BRDH baud high divisor

   outp(port + MCR,0x0B);                    // Set MCR user output 2 to enable ints and DTR line
   
   if(toupper(gpsprty) == 'N') tmp =  0;
   if(toupper(gpsprty) == 'E') tmp =  0x18;
   if(toupper(gpsprty) == 'O') tmp =  0x08;

   tmp |= (gpsnbit-5) ;
   tmp |= (gpssbit-1) << 2;

   outp(port + LCR, tmp & 0x1F);            // Reset Bit 7 to zero for TXR and RDR

   return 0;
}
  
//=====================================================================

short _out_InitPort(short port, short IRQ, long rate, char outprty, short outnbit, short outsbit)
{
   short tmp;

//   if(!IsIrqAvail(IRQ)) return 1;            // Check for used IRQ's
//   if(IsPortAvail(port)!=1) return 2;        // Look for avaiable serial ports

   outp(port + IER,0x00);                    // Disable comm port interrupts
   outp(port + LCR,0x80);                    // Set bit 7 on LCR to enable BRDL and BRDH

   outp(port, (BYTE)(115200/rate)&0xFF);           // BRDL , low baud divisor
   outp(port + IER,(BYTE)(115200/rate)>>8);        // BRDH baud high divisor

   outp(port + MCR,0x0B);                    // Set MCR user output 2 to enable ints and DTR line
   
   if(toupper(outprty) == 'N') tmp =  0;
   if(toupper(outprty) == 'E') tmp =  0x18;
   if(toupper(outprty) == 'O') tmp =  0x08;

   tmp |= (outnbit-5) ;
   tmp |= (outsbit-1) << 2;

   outp(port + LCR, tmp & 0x1F);            // Reset Bit 7 to zero for TXR and RDR

   return 0;
}
  
void CloseGPS(void)
{
   if(!gps_open) return;
   CloseDGPS();

   _gps_ReleaseIRQ(gpsirq);
   _dos_setvect(gpsvector, old_serial);

   outp(gpsport + IER,0x00);
   outp(gpsport + MCR,0x00);
  
   gps_open = 0;

   return;
}

void CloseDGPS(void)
{
   if(!dgps_open) return;

   _gps_ReleaseIRQ(difirq);
   _dos_setvect(difvector, old_dgps);

   outp(difport + IER,0x00);
   outp(difport + MCR,0x00);
   
   dgps_open = 0;
   
   return;
}
void CloseOut(void)
{
   if(!out_open) return;

   _out_ReleaseIRQ(outirq);
   _dos_setvect(outvector, old_out);

   outp(outport + IER,0x00);
   outp(outport + MCR,0x00);
   
   out_open = 0;
   
   return;
}

void cfg_defaults(void)
{
      // set cfg defaults     
      DataType = Z_BINARY; datum = 0; utcoffset = 7; spdunits = 0;
      ref_lat = 33.66221083f; ref_lon = -117.86265997f;  ref_alt = -3.31f;      
      MainTextColor = 10; MainDataColor = 15; MainBackColor =  0;
      MenuKeysColor = 14; MenuDescColor = 15; MenuBackColor = 10;
}

void write_cfg(void)
{  
   // use a data type of 0 for navcore for bacward compatibility
   short temp_type; 
       
   // change new value of navcore data type to old type 
   temp_type = DataType;
   if(temp_type == NC_BINARY) temp_type = 0;
    
   fprintf(cfgdata,"DATA TYPE %d\nDATUM NUMBER %u\nUTC OFFSET %d\nSPD UNITS %d\n",
           temp_type, datum, utcoffset, spdunits);  
              
   fprintf(cfgdata,"COLORS %d %d %d %d %d %d\nLAT %lf LON %lf ALT %lf\n",
           MainTextColor, MainDataColor, MainBackColor, 
           MenuKeysColor, MenuDescColor, MenuBackColor,
           ref_lat, ref_lon, ref_alt); 
   
   fprintf(cfgdata,
         "FILTERS STATMASK %04X FOM %d QUALITY %d SATS %d PDOP %f HDOP %f VDOP %f",
          StatMask, minfom, minqual, minsats, maxpdop, maxhdop, maxvdop); 
} 

void save_cfg(void)
{
   // write to a new cfg file
   if((cfgdata = _fsopen("labmon.cfg", "w", SH_DENYWR)) != NULL){
      write_cfg();
      fclose(cfgdata);
   }
} 

void proc_cfg(void)
{      
   short fileerr; 
   short filestat1 = 0;
   short filestat2 = 0;   
   short filestat3 = 0;
   
   if((cfgdata = _fsopen("labmon.cfg", "r", SH_DENYWR)) == NULL){
      // file does not exist
      fileerr = 1;
   }
   else{
      // scan cfg file if it exists
      filestat1 = fscanf(cfgdata,
                  "DATA TYPE %d\n DATUM NUMBER %u\n UTC OFFSET %d\n SPD UNITS %d\n",
                  &DataType, &datum, &utcoffset, &spdunits);  
              
      filestat2 = fscanf(cfgdata,
                  "COLORS %d %d %d %d %d %d\nLAT %lf LON %lf ALT %lf\n",
                  &MainTextColor, &MainDataColor, &MainBackColor, 
                  &MenuKeysColor, &MenuDescColor, &MenuBackColor,
                  &ref_lat, &ref_lon, &ref_alt);   
                  
      filestat3 = fscanf(cfgdata,
          "FILTERS STATMASK %04X FOM %d QUALITY %d SATS %d PDOP %f HDOP %f VDOP %f",
           &StatMask, &minfom, &minqual, &minsats, &maxpdop, &maxhdop, &maxvdop);
                  
      if(filestat1 == EOF || filestat1 != 4 ||
         filestat2 == EOF || filestat2 != 9 ||
         filestat3 == EOF || filestat3 != 7  ){ 
         
         // cfg read error, replace 
         fileerr = 1;
      }
      else{
         fileerr = 0;
      }
      fclose(cfgdata);   
   }
   // change old value of navcore data type to new type
   if(DataType == 0) DataType = NC_BINARY;

   // create a new file
   if(fileerr){
      if((cfgdata = _fsopen("labmon.cfg", "w", SH_DENYWR)) != NULL){
         cfg_defaults();
         write_cfg();
         fclose(cfgdata);  
      }
   }
}

void ini_defaults(void)
{
   // if no ini file, set defaults and create one
   gpscom  = 1; gpsirq  = 4;   gpsbaud = 9600;
   gpsnbit = 8; gpsprty = 'N'; gpssbit = 1;      
     
   difcom  = 0; difirq  = 3;   difbaud = 9600;
   difnbit = 8; difprty = 'N'; difsbit = 1;   

   // removed capability for this version
   /*outcom = 0; outirq  = 3;   outbaud = 9600;
   outnbit = 8; outprty = 'n'; outsbit = 1; */
}

void write_ini(void)
{
   fprintf(inidata,"GPS  COM%d IRQ%d %ld %c %d %d\n",
           gpscom, gpsirq, gpsbaud, gpsprty, gpsnbit, gpssbit);
   fprintf(inidata,"RTCM COM%d IRQ%d %d %c %d %d\n",
           difcom, difirq, difbaud, difprty, difnbit, difsbit); 
      
   // removed capability for this version  
   /*fprintf(inidata,"PLAY COM%d IRQ%d %d %c %d %d\n",
   outcom, outirq, outbaud, outprty, outnbit, outsbit);*/
}

void save_ini(void)
{
   // write to a new ini file
   if((inidata = _fsopen("labmon.ini", "w", SH_DENYWR)) != NULL){
      write_ini();
      fclose(inidata);
   } 
}     

void proc_ini(void)
{      
   short fileerr   = 0; 
   short filestat1 = 0;
   short filestat2 = 0;
   
   if((inidata = _fsopen("labmon.ini", "r", SH_DENYWR)) == NULL){
      // file does not exist
      fileerr = 1;
   }
   else{
      // scan ini file if it exists
      filestat1 = fscanf(inidata,"GPS  COM%d IRQ%d %ld %c %d %d\n",
                  &gpscom, &gpsirq, &gpsbaud, &gpsprty, &gpsnbit, &gpssbit);
      filestat2 = fscanf(inidata,"RTCM COM%d IRQ%d %d %c %d %d\n",
                  &difcom, &difirq, &difbaud, &difprty, &difnbit, &difsbit);
      if(filestat1 == EOF || filestat1 != 6 ||
         filestat2 == EOF || filestat2 != 6){
      
         // ini read error, replace 
         fileerr = 1;
       }
      else{
         fileerr = 0;
      }
      fclose(inidata);
   }
   // create a new file
   if(fileerr){
      if((inidata = _fsopen("labmon.ini", "w", SH_DENYWR)) != NULL){
         ini_defaults();
         write_ini();
         fclose(inidata);  
      }
   }
}
 
void proc_args(short argc, char *argv[])
{
   int i;
   if(argc > 1){
     for(i=1; i<argc+1; i++){
       if(argv[i][0]=='-'){
         switch(argv[i][1]){
           case 'R': // record gps port
           case 'r': //
             if((stream = _fsopen(argv[i]+2, "wb", SH_DENYWR )) == NULL){
               cprintf("Couldn't open file %s!\7\r\n",argv[i]+2);
               exit(0);
             }
             else{
//               fclose(stream);
               save = 1;
             } 
             break;
           case 'S': // save dgps port data
           case 's': //
             if((stream2 = _fsopen(argv[2], "wb", SH_DENYWR)) == NULL){
               cprintf("Couldn't open file %s!\7\r\n",argv[2]);
               exit(0);
             }
             else{
               save2 = 1;
             }
             break;
           case 'D': // debug mode
           case 'd': //
			 if (argv[i][2] == 'r' || argv[i][2] == 'R') {
			   if (argv[i][3] == 'e' || argv[i][3] == 'E') {
			     DisplayDRError = 1;
			   } else {
			     Display1070 = 1;
			   }
			 } else {
               DEBUG = TRUE;
			 }
             break;
           case 'C': // default configuration 
           case 'c': //
             gpscom  = atoi(&argv[i][2]);
             switch(gpscom){ // get irq for com
               case 1:
                 gpsirq  = 4;
                 break;
               case 2:
                 gpsirq  = 3;
                 break;
               case 3:
                 gpsirq  = 4;
                 break;
               case 4:
                 gpsirq  = 3;
                 break;
               default:
                 break;
             } // end switch irq          
             switch(argv[i][3]){ // get protocol
               case 'Z': // zodiac
               case 'z':
                 switch(argv[i][4]){
                   case 'B': // binary
                   case 'b':
                     DataType = Z_BINARY;
                     gpsbaud = 9600;
                     gpsprty = 'N';
                     gpsnbit = 8;
                     gpssbit = 1;
                     break;
                   case 'N': // nmea
                   case 'n':
                     DataType = Z_NMEA;
                     gpsbaud = 4800;
                     gpsprty = 'N';
                     gpsnbit = 8;
                     gpssbit = 1;
                     break;
                   default:
                     break;
                 } // end switch zodiac b/n
                 break;
               case 'N': // navcore
               case 'n': 
                 switch(argv[i][4]){
                   case 'B': // binary
                   case 'b':
                     DataType = NC_BINARY;
                     gpsbaud = 9600;
                     gpsprty = 'N';
                     gpsnbit = 8;
                     gpssbit = 1;
                     break;
                   case 'N': // nmea
                   case 'n':
                     DataType = NC_NMEA;
                     gpsbaud = 4800;
                     gpsprty = 'O';
                     gpsnbit = 8;
                     gpssbit = 1;
                     break;
                   default:
                     break;
                 } // end switch navcore b/n
                 break;
               default:
                 break;
             } // end switch zodiac/navcore
         } // end switch argv i1
       } // end if '-'
     } // end for
   } // end if argc > 1
}       

void reset_count(void)
{  
   cnt101  = 0; cnt102  = 0; cnt103  = 0; cnt104  = 0;
   cnt105  = 0; cnt106  = 0; cnt107  = 0; cnt111  = 0;
   cnt112  = 0; cnt113  = 0; cnt117  = 0; cnt152  = 0;
   cnt153  = 0; cnt201  = 0; cnt202  = 0; cnt203  = 0;
   cnt204  = 0; cnt205  = 0; cnt206  = 0; cnt207  = 0;
   cnt208  = 0; cnt209  = 0; cnt210  = 0; cnt211  = 0;
   cnt213  = 0; cnt217  = 0; cnt220  = 0; cnt2309 = 0;
   cnt2319 = 0; cntnack = 0; cntncs  = 0; cnthcs  = 0;
   cntdcs  = 0; cntovf  = 0; cntnack = 0; cntncs  = 0;
   cnthcs  = 0; cntdcs  = 0; cntovf  = 0; cntalm  = 0;
   cntgga  = 0; cntgll  = 0; cntgsa  = 0; cntgsv  = 0;
   cntrmc  = 0; cntvtg  = 0; cntzda  = 0; cntalt  = 0;
   cntcom  = 0; cntdgp  = 0; cntinit = 0; cntlog  = 0;
   cntq    = 0; cntftst = 0; cntgen  = 0; cnticom = 0; cntidgp = 0;
   cntzch  = 0; cnterr  = 0; cntrid  = 0; cntsyn  = 0;
   cntipro = 0; cntilog = 0; cntibit = 0; cntbit  = 0;
   
   Cnt1000 = 0; Cnt1001 = 0; Cnt1002 = 0; Cnt1003 = 0;
   Cnt1005 = 0; Cnt1007 = 0; Cnt1008 = 0; Cnt1009 = 0; Cnt1011 = 0; Cnt1012 = 0;
   Cnt1040 = 0; Cnt1041 = 0; Cnt1042 = 0; Cnt1050 = 0; Cnt1051 = 0;
   Cnt1070 = 0; Cnt1071 = 0; Cnt1072 = 0; Cnt1075 = 0, Cnt1090 = 0, Cnt1091 = 0;
   Cnt1092 = 0; Cnt1100 = 0; Cnt1102 = 0; Cnt1106 = 0; Cnt1108 = 0; 
   Cnt1110 = 0; Cnt1117 = 0; Cnt1130 = 0; Cnt1135 = 0; Cnt1136 = 0; 
   Cnt1137 = 0; Cnt1150 = 0; Cnt1160 = 0; Cnt1170 = 0; Cnt1171 = 0; 
   Cnt1172 = 0; Cnt1173 = 0; Cnt1180 = 0; Cnt1190 = 0; Cnt1191 = 0;
   Cnt1200 = 0; Cnt1208 = 0; Cnt1210 = 0; Cnt1211 = 0; Cnt1212 = 0;
   Cnt1213 = 0; Cnt1214 = 0; Cnt1216 = 0; Cnt1217 = 0;
   Cnt1218 = 0; Cnt1219 = 0; Cnt1220 = 0; Cnt1221 = 0;
   Cnt1240 = 0; Cnt1241 = 0; Cnt1242 = 0; Cnt1270 = 0; Cnt1292 = 0;
   Cnt1300 = 0; Cnt1303 = 0; Cnt1304 = 0; Cnt1305 = 0;
   Cnt1306 = 0; Cnt1310 = 0; Cnt1317 = 0; Cnt1330 = 0;
   Cnt1331 = 0; Cnt1334 = 0; Cnt1337 = 0; Cnt1350 = 0; Cnt1351 = 0; 
   Cnt1360 = 0; Cnt1380 = 0;
   CntZLog = 0; CntZQry = 0; 
}  
 
void clear_count(void)
{       
   short row;
   
   for(row= 0; row < 18; row++){           //row < 15
      _settextposition(CNTR + row, CNTC); 
      _outtext(Clear);      
   }
}

short msg_support(short msg_type)
{
   // msg_type : NavCore binary = 1, NavCore NMEA = 2,
   //            Zodiac binary  = 4, Zodiac NMEA  = 8
   if(msg_type & DataType){
      return 1;
   }
   else{ 
   // beep and pause briefly 
      clear_message_line();
      _outtext("COMMAND NOT SUPPORTED WITH CURRENT MESSAGE PROTOCOL");
      cputs("\a\a");
      wait(1.f);
      return 0;
   }
} 

void wait(float twait)
{
    double systime;
    double curtime;
    double endtime;
  
    _ftime(&timebuffer);
    systime = (double) (timebuffer.time + timebuffer.millitm * .001);     
    curtime = systime; 
    endtime = curtime + (float) twait; 
    while(curtime < endtime){
       _ftime(&timebuffer);
       systime = (double) (timebuffer.time + timebuffer.millitm * .001);     
       curtime = systime; 
    } 
}
  
void reset_dtime(void)
{
    double systime;

    _ftime(&timebuffer);
    systime = (double) (timebuffer.time + timebuffer.millitm * .001);     
    cnttime_ref = systime;
} 

void clear_screen(void)
{
   _clearscreen(_GCLEARSCREEN);
   if(TERMINAL) return; 
   rockwell_link = 0;
   show_screen_titles();
   display_title();
      
   if(!menu_on){
      show_count();
   }
   else{
      display_menus(&current_menu);
   }
} 

void show_xtract(short flag)
{
   _settextposition(CMDR-3,CNTC+2); 
   if(flag){
      if(fxtract){
         _outtext("FXTRACT ON");         
      }
      else if(xtract){
         _outtext("XTRACT ON");         
      }
   }
   else{
      _outtext("              ");          
   }
}


void show_filter(short flag)
{
   if(TERMINAL) return;
   
   _settextposition(CMDR-2,CNTC+2); 
   if(flag){
      _outtext("FILTER ON");         
   }
   else{
      _outtext("         ");          
   }
}

short extract(char *b,char *f[],short n)
{
   short i,j,k,len;
   
   len = strlen(b);
   if(len <= 0) return(0);             // no chars in string
   j=0;                                // field index 0..n-1
   k=0;                                // char index     
   
   for(i=0; i<len; i++){   
   
      if(k == 0){
         f[j] = b+i;           // point to start of string    
      }      
     
      if(i==len-1 || b[i]=='*'){        
          // last field found 
          b[i] = '\0';               // terminate field with null 
          return(j+1);
      }
      else if(b[i]=='\0'){        
          // last field found 
          return(j);
      }
      else if(b[i]== ','){ 
         // end of current field found  
         b[i] = '\0';               // terminate field with null
         k = 0;                     // first char
         j++;                       // of next field        
      }
      else{
         k++;                        // move to next character  
      } 
      
      if(j == n){
         return(j);            // out of pointers
      }
   }
   return(j);
}

// determine interrupt vector from an irq
unsigned short vector(unsigned short irq)
{
   unsigned short  vector;
   // determine interrupt vector for IRQ 
   if(irq < 8)       vector = irq     + 0x08; // master offset (08h)
   else              vector = (irq-8) + 0x70; // slave offset  (70h)

   return vector;
}

short get_msgid_from_field_name()
{
   char  *field = " ";
   short i=0,j=0;
   
   ask_str("ENTER FIELD NAME FROM ABOVE TO LOG -> ", field, &valid);   
   
   if     ( stricmp ( field,  "AGE" ) == 0 )            return 1005;
   else if( stricmp ( field,  "ALT" ) == 0 )            return 1000;
   else if( stricmp ( field,  "ANTYPE" ) == 0 )         return 1012;
   else if( stricmp ( field,  "AZI" ) == 0 )            return 1003;
   else if( stricmp ( field,  "CARRIERPHASE" ) == 0 )   return 1102;
   else if( stricmp ( field,  "CB" ) == 0 )             return 1000;
   else if( stricmp ( field,  "CBS" ) == 0 )            return 1000;
   else if( stricmp ( field,  "CD" ) == 0 )             return 1000;
   else if( stricmp ( field,  "CDS" ) == 0 )            return 1000;
   else if( stricmp ( field,  "CH" ) == 0 )             return 1002;
   else if( stricmp ( field,  "CLM" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "CN" ) == 0 )             return 1002; 
   else if( stricmp ( field,  "COG" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "COLDTO" ) == 0 )         return 1012; 
   else if( stricmp ( field,  "CSW1" ) == 0 )           return 1102; 
   else if( stricmp ( field,  "CSW2" ) == 0 )           return 1102; 
   else if( stricmp ( field,  "DATE" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "DATUM" ) == 0 )          return 1012; 
   else if( stricmp ( field,  "DAY" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "DGPSTO" ) == 0 )         return 1012; 
   else if( stricmp ( field,  "ECULRTI" ) == 0 )        return 1005; 
   else if( stricmp ( field,  "EHPE" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "EHVE" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "EL" ) == 0 )             return 1003; 
   else if( stricmp ( field,  "ENAB" ) == 0 )           return 1012;
   else if( stricmp ( field,  "ETE" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "EVPE" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "GDOP" ) == 0 )           return 1003; 
   else if( stricmp ( field,  "GPSSEC" ) == 0 )         return 1000; 
   else if( stricmp ( field,  "GSEP" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "GPSNSEC" ) == 0 )        return 1000; 
   else if( stricmp ( field,  "HDOP" ) == 0 )           return 1003;
   else if( stricmp ( field,  "HLTH" ) == 0 )           return 1005; 
   else if( stricmp ( field,  "INVAL" ) == 0 )          return 1000;
   else if( stricmp ( field,  "LAT" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "LON" ) == 0 )            return 1000;
   else if( stricmp ( field,  "M" ) == 0 )              return 1000;
   else if( stricmp ( field,  "MAG" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "MASK" ) == 0 )           return 1012; 
   else if( stricmp ( field,  "MEHPE" ) == 0 )          return 1012;
   else if( stricmp ( field,  "MEVPE" ) == 0 )          return 1012; 
   else if( stricmp ( field,  "NVIS" ) == 0 )           return 1003; 
   else if( stricmp ( field,  "PLAT" ) == 0 )           return 1012; 
   else if( stricmp ( field,  "POLAR" ) == 0 )          return 1000; 
   else if( stricmp ( field,  "PORT1" ) == 0 )          return 1130; 
   else if( stricmp ( field,  "PORT2" ) == 0 )          return 1130; 
   else if( stricmp ( field,  "POSX" ) == 0 )           return 1001; 
   else if( stricmp ( field,  "POSY" ) == 0 )           return 1001; 
   else if( stricmp ( field,  "POSZ" ) == 0 )           return 1001; 
   else if( stricmp ( field,  "PSEUDO RANGE" ) == 0 )   return 1102;
   else if( stricmp ( field,  "RANGRATE" ) == 0 )       return 1102; 
   else if( stricmp ( field,  "SATS" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "SPD" ) == 0 )            return 1000; 
   else if( stricmp ( field,  "STAT" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "STATUS" ) == 0 )         return 1005; 
   else if( stricmp ( field,  "STNID" ) == 0 )          return 1005; 
   else if( stricmp ( field,  "SV" ) == 0 )             return 1002;
   else if( stricmp ( field,  "TDOP" ) == 0 )           return 1003; 
   else if( stricmp ( field,  "TYPE" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "UTC TIME" ) == 0 )       return 1108; 
   else if( stricmp ( field,  "UVEC" ) == 0 )           return 1002;
   else if( stricmp ( field,  "VALID" ) == 0 )          return 1012;
   else if( stricmp ( field,  "VDOP" ) == 0 )           return 1003; 
   else if( stricmp ( field,  "VELX" ) == 0 )           return 1001; 
   else if( stricmp ( field,  "VELY" ) == 0 )           return 1001;
   else if( stricmp ( field,  "VELZ" ) == 0 )           return 1001; 
   else if( stricmp ( field,  "WEEK" ) == 0 )           return 1000; 
   else if( stricmp ( field,  "XSV" ) == 0 )            return 1012; 
   else{
      sprintf(buff,
             "FIELD NAME %s NOT RECOGNIZED, CHECK SPELLING AND TRY AGAIN! ",field);
      clear_message_line();
      _outtext(buff);
      return 0;
   }
}


void WatchDog(void)
{
    double systime;
    static double endtime;
    extern char    NavigationMode[6];
    extern tSHORT  NumTrkSats;
    
    _ftime(&timebuffer);
    systime = (double) (timebuffer.time + timebuffer.millitm * .001);     

    switch(WDState){
      
      case sWaitNav:
        if( !strcmp(NavigationMode, "  NAV") ) WDState = sWaitAck;
        break;
        
      case sWaitAck:
        if( !strcmp(NavigationMode, "  ACQ") ) WDState = sCheckSats;
        break;
      
      case sCheckSats:
        if(NumTrkSats == 0){
          FirstTime = 1;
          WDState = sWatchDog;
        }  
        else{
          WDTimeRemaining = WDTimeOut;
          WDState = sWaitNav;
        }  
        break;
        
      case sWatchDog:
        if(FirstTime){ // set timer
          FirstTime = 0;
          endtime = systime + (float) WDTimeOut;
        }


        if(endtime < systime){ // timer expired
          WDTimeRemaining = WDTimeOut;
          WDState = sWaitNav;
          
          // reset counters and send reset message
          reset_count();   
 
          memset(&ZMsg.Msg1303, 0, sizeof(ZMsg.Msg1303));
            
          memset(&CommandWord, 0, sizeof(tCOMMANDWORD));
//          CommandWord.InvalidateRAM    = 0;
//          CommandWord.InvalidateEEPROM = 0;
//          CommandWord.InvalidateRTC    = 0;
//          CommandWord.ForceColdStart   = 0;

          BldZMsg(&ZMsgBuf, ZMsg, 1303);
          memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1303) + HDR_LEN);
          Cnt1303++;
          send_msg(tx_buff);
      
          reset_dtime();
          if(!menu_on){
             clear_count();
          }
          clear_screen();
          clear_message_line(); 
          _outtext("RESTARTING RECEIVER");
          FlushGPS();
          wait(1.f);
        } 
        else{
          WDTimeRemaining = (unsigned short) (endtime - systime);                                    
          
          if( !strcmp(NavigationMode, "  NAV") ){
            WDTimeRemaining = WDTimeOut;
            WDState = sWaitAck;
          }  
        }
        break;

      default: 
        break;           
    }   

}

short get_send_file(void)
{
   char  FileName[35]="";
   short   valid;                                            

   clear_message_line();
   ask_str("SEND FILE NAME -> ", FileName, &valid);
   clear_message_line(); 
   if(!valid) return(1);     
   clear_message_line(); 
      
   if((Send_FilePtr = _fsopen(FileName, "rb", SH_DENYWR)) == NULL){
      clear_message_line();
      _outtext("COULDN'T OPEN SEND FILE!\7");
      return(1);
   }
   else{
      return(0);
   }
}


void Send_File(void)
{
   KeyboardType  kb;       
      
   // loop - read Send_Byte from input file and send to serial
   clear_message_line();
   _outtext("SENDING FILE");
   while( (Send_Byte=fgetc(Send_FilePtr)) != EOF ){       // get byte from file
     send_byte((BYTE)Send_Byte);                          // send byte to port
     // check keyboard
     if(kbhit()){
       kb = getkey(GETKEY);
       if(kb.scan == 1){ // check for escape key
         clear_message_line();
         _outtext("SEND INTERRUPTED");
         return;
       } // end check escape key
     } // end check keyboard   
   } // end while
   clear_message_line();
   _outtext("FILE SENT");
   return;
} //end Send_File


void DoExplicitAck(tSHORT msgID, tBOOL Status)
{
	static int Count=0;

	switch (msgID)
	{
		case 1106:
        // if(BlockID < VEEPROM_NUM_BLOCKS)  {
		//		break;        
		//	}
		//	else {
		//		BlockID = 0;
		//	}
         break;

		case 1137: 
            if(*(tSHORT *)&msgbuff[6] != 0) return; // won't explct ack to regular ack input
			ZMsg.Msg1306.SequenceNumber = 0;
            ZMsg.Msg1306.MsgID = msgID;
			if(Status) { 
            	ZMsg.Msg1306.AckStatus = 0x0001;    // positive ack, set bit 0
            }
            else {
                ZMsg.Msg1306.AckStatus = 0x0002;    // negative ack, set bit 1   
            }
            ZMsg.Msg1306.Reserved1 = 0;
            ZMsg.Msg1306.Reserved2 = 0;
            BldZMsg(&ZMsgBuf, ZMsg, 1306);
        	memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1306) + HDR_LEN); 
        	Cnt1306++;       
        	send_msg(tx_buff);
         	break;
			
        default:
         	break;
    }
}


void DovEEPBlockInput(void)
{ 
	int i,j;
	tUSHORT vEEPData[128];
	

   	// Fill the buffer from an external file before you transfer the data.
   	if (vEEPResend==0)
   	{         
	  	ZMsg.Msg1334.SequenceNumber = 0;
			
      	// If we have a vEEPROM saved then tell the RX it is valid.
      	// Else tell the RX it is NOT valid.
      	if ((vEEPROMFilePtr = fopen("veeprom.dat","rb")) == NULL) {
      		vEEPAvailable       = FALSE;
         	ZMsg.Msg1334.Status = 0x0;
        }
      	else {            
      		vEEPAvailable       = TRUE;
         	ZMsg.Msg1334.Status = 0x1; 
        }

	  	ZMsg.Msg1334.Reserved1 = 0;
	  	ZMsg.Msg1334.Reserved2 = 0; 
	  	BldZMsg(&ZMsgBuf, ZMsg, 1334);
	  	memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1334) + HDR_LEN); 
	  	Cnt1334++;       
	  	send_msg(tx_buff);  
      	wait(0.5f);
        
        if(!vEEPAvailable) {
         	return;
        }

        // First get the size of the vEEPROM.
        vEEPROM_file_size = fgetc(vEEPROMFilePtr) & 0xFF;
        vEEPROM_file_size |= ((fgetc(vEEPROMFilePtr) & 0xFF) << 8);
                                                  
        if (vEEPROM_file_size > VEEPROM_NUM_WORDS)
        	vEEPROM_file_size = VEEPROM_NUM_WORDS;               

        // Now get the vEEPROM data.
        for (i=0; i<vEEPROM_file_size; i++) 
        {
        	TempStore[i]  =   fgetc(vEEPROMFilePtr) & 0xFF;
            TempStore[i] |= ((fgetc(vEEPROMFilePtr) & 0xFF) << 8);
        }

        fclose(vEEPROMFilePtr);
   	}
   
    
    if(vEEPAvailable) 
    { 
    
    	vEEPTransferInProgress = TRUE;
    
   		for(j=0; j<VEEPROM_NUM_BLOCKS; j++) {
    
    		if(((vEEPBlockBitMap >> j) & 0x0001) == 0) {
    	
    			// Get 128 words for the vEEPROM block transfer.
				for(i=0; i<128; i++) {
	   				vEEPData[i] = TempStore[((j)*128)+i];
                }

//HP TEST CODE : Force vEEP block 6,10,14 to have wrong checksums to test
//HP TEST CODE : the rx's response to the failed condition
//HP vEEP			    if((j==5 || j==9 || j==13) && (vEEPResend==0)) {
//HP					vEEPTest = TRUE;
//HP				}
                 
    			// Send the vEEPROM Block.      
				ZMsg.Msg1337.SequenceNumber = 0;
				ZMsg.Msg1337.BlockID        = j;
    			ZMsg.Msg1337.BlockTotal     = VEEPROM_NUM_BLOCKS;
				memcpy(&ZMsg.Msg1337.DataWord, vEEPData, sizeof(vEEPData)); 
				BldZMsg(&ZMsgBuf, ZMsg, 1337);
				memcpy(tx_buff, &ZMsgBuf, sizeof(ZMsg.Msg1337) + HDR_LEN); 
				Cnt1337++;
				send_msg(tx_buff);  
				
				vEEPTest = FALSE;
//HP TEST CODE   sprintf(buff,"%3d",vEEPResend);
//HP vEEP   ShowText(buff,41,30);
			}
             
//HP TEST CODE : test the 2mins comm. silence. The Rx will output 1106 four times
//HP vEEP      : with the bit map block status.  Labmon will resend the blocks
//HP           : corresponding to the un-filled bits.  The test below will initiate
//HP           : the comm silence for the vEEPResend == 0 and vEEPResend == 1.  The
//HP 		   : un-filled bit(s) will have its corresponding block(s) sent at
//HP		   : vEEPResend == 2                
//HP            if(j==14) { 
//HP      		if(vEEPResend <= 1) {
//HP  	  	    	wait(2.1f);      
//HP    	  	    	break;
//HP    	  		}
//HP    	  	}
		}
	}
}		
